"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ZOOM_FACTOR_DEFAULT = exports.EuiTimeWindowButtons = void 0;
exports.useEuiTimeWindow = useEuiTimeWindow;
var _react = _interopRequireDefault(require("react"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _pretty_interval = require("./pretty_interval");
var _relative_utils = require("./relative_utils");
var _button_group_button = require("../../button/button_group/button_group_button");
var _button_group = require("../../button/button_group/button_group.styles");
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var ZOOM_FACTOR_DEFAULT = exports.ZOOM_FACTOR_DEFAULT = 0.5;
/**
 * Button group with time window controls for shifting the time window
 * forwards and backwards, and zooming out.
 */
var EuiTimeWindowButtons = exports.EuiTimeWindowButtons = function EuiTimeWindowButtons(_ref) {
  var applyTime = _ref.applyTime,
    start = _ref.start,
    end = _ref.end,
    compressed = _ref.compressed,
    isDisabled = _ref.isDisabled,
    _ref$showZoomOut = _ref.showZoomOut,
    showZoomOut = _ref$showZoomOut === void 0 ? true : _ref$showZoomOut,
    _ref$showShiftArrows = _ref.showShiftArrows,
    showShiftArrows = _ref$showShiftArrows === void 0 ? true : _ref$showShiftArrows,
    _ref$zoomFactor = _ref.zoomFactor,
    zoomFactor = _ref$zoomFactor === void 0 ? ZOOM_FACTOR_DEFAULT : _ref$zoomFactor;
  var buttonColor = 'text';
  var buttonSize = compressed ? 's' : 'm';
  var iconSize = compressed ? 's' : 'm';
  var styles = (0, _services.useEuiMemoizedStyles)(_button_group.euiButtonGroupButtonsStyles);
  var _useEuiTimeWindow = useEuiTimeWindow(start, end, applyTime, {
      zoomFactor: zoomFactor
    }),
    displayInterval = _useEuiTimeWindow.displayInterval,
    isInvalid = _useEuiTimeWindow.isInvalid,
    stepForward = _useEuiTimeWindow.stepForward,
    stepBackward = _useEuiTimeWindow.stepBackward,
    expandWindow = _useEuiTimeWindow.expandWindow;
  var invalidShiftDescription = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.invalidShiftLabel', 'Cannot shift invalid time window');
  var invalidZoomOutDescription = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.invalidZoomOutLabel', 'Cannot zoom out invalid time window');
  var previousId = (0, _services.useGeneratedHtmlId)({
    prefix: 'previous'
  });
  var previousLabel = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.previousLabel', 'Previous');
  var previousTooltipContent = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.previousDescription', 'Previous {displayInterval}', {
    displayInterval: displayInterval
  });
  var zoomOutId = (0, _services.useGeneratedHtmlId)({
    prefix: 'zoom_out'
  });
  var zoomOutLabel = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.zoomOutLabel', 'Zoom out');
  var zoomOutTooltipContent = isInvalid ? invalidZoomOutDescription : zoomOutLabel;
  var nextId = (0, _services.useGeneratedHtmlId)({
    prefix: 'next'
  });
  var nextLabel = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.nextLabel', 'Next');
  var nextTooltipContent = (0, _i18n.useEuiI18n)('euiTimeWindowButtons.nextDescription', 'Next {displayInterval}', {
    displayInterval: displayInterval
  });
  if (!showZoomOut && !showShiftArrows) return null;
  return (0, _react2.jsx)("div", {
    className: "euiSuperDatePicker__timeWindowButtons",
    css: [styles.euiButtonGroup__buttons, styles[buttonSize], ";label:EuiTimeWindowButtons;"],
    "data-test-subj": "timeWindowButtons"
  }, showShiftArrows && (0, _react2.jsx)(_button_group_button.EuiButtonGroupButton, {
    id: previousId,
    "data-test-subj": "timeWindowButtonsPrevious",
    label: previousLabel,
    title: "",
    toolTipContent: !isDisabled && (isInvalid ? invalidShiftDescription : previousTooltipContent),
    color: buttonColor,
    size: buttonSize,
    iconType: "arrowLeft",
    iconSize: iconSize,
    isIconOnly: true,
    isSelected: false,
    isDisabled: isDisabled,
    onClick: stepBackward
  }), showZoomOut && (0, _react2.jsx)(_button_group_button.EuiButtonGroupButton, {
    id: zoomOutId,
    "data-test-subj": "timeWindowButtonsZoomOut",
    label: zoomOutLabel,
    title: "",
    toolTipContent: !isDisabled && zoomOutTooltipContent,
    toolTipProps: {
      disableScreenReaderOutput: zoomOutLabel === zoomOutTooltipContent
    },
    color: buttonColor,
    size: buttonSize,
    iconType: "magnifyWithMinus",
    iconSize: iconSize,
    isIconOnly: true,
    isSelected: false,
    isDisabled: isDisabled,
    onClick: expandWindow
  }), showShiftArrows && (0, _react2.jsx)(_button_group_button.EuiButtonGroupButton, {
    id: nextId,
    "data-test-subj": "timeWindowButtonsNext",
    label: nextLabel,
    title: "",
    toolTipContent: !isDisabled && (isInvalid ? invalidShiftDescription : nextTooltipContent),
    color: buttonColor,
    size: buttonSize,
    iconType: "arrowRight",
    iconSize: iconSize,
    isIconOnly: true,
    isSelected: false,
    isDisabled: isDisabled,
    onClick: stepForward
  }));
};

/**
 * Partly adapted from date_picker/super_date_picker/quick_select_popover/quick_select.tsx
 */
function useEuiTimeWindow(start, end, apply, options) {
  var _options$zoomFactor;
  var min = _datemath.default.parse(start);
  var max = _datemath.default.parse(end, {
    roundUp: true
  });
  var isInvalid = !min || !min.isValid() || !max || !max.isValid();
  var windowDuration = isInvalid ? 1 : max.diff(min);
  var zoomFactor = getPercentageMultiplier((_options$zoomFactor = options === null || options === void 0 ? void 0 : options.zoomFactor) !== null && _options$zoomFactor !== void 0 ? _options$zoomFactor : ZOOM_FACTOR_DEFAULT);
  var zoomAddition = windowDuration * (zoomFactor / 2); // Gets added to each end, that's why it's split in half
  var prettyInterval = (0, _pretty_interval.usePrettyInterval)(false, windowDuration);
  var displayInterval = isInvalid ? '' : prettyInterval;
  if (!isInvalid && !(0, _relative_utils.isRelativeToNow)(start, end) && !isExactMinuteRange(windowDuration)) {
    displayInterval = "~".concat(displayInterval);
  }
  return {
    displayInterval: displayInterval,
    isInvalid: isInvalid,
    stepForward: stepForward,
    stepBackward: stepBackward,
    expandWindow: expandWindow
  };
  function stepForward() {
    if (isInvalid) return;
    apply({
      start: (0, _moment.default)(max).toISOString(),
      end: (0, _moment.default)(max).add(windowDuration, 'ms').toISOString()
    });
  }
  function stepBackward() {
    if (isInvalid) return;
    apply({
      start: (0, _moment.default)(min).subtract(windowDuration, 'ms').toISOString(),
      end: (0, _moment.default)(min).toISOString()
    });
  }
  function expandWindow() {
    if (isInvalid) return;
    apply({
      start: (0, _moment.default)(min).subtract(zoomAddition, 'ms').toISOString(),
      end: (0, _moment.default)(max).add(zoomAddition, 'ms').toISOString()
    });
  }
}

/**
 * Get a number out of either 0.2 or "20%"
 */
function getPercentageMultiplier(value) {
  var result = typeof value === 'number' ? value : parseFloat(String(value).replace('%', '').trim());
  if (isNaN(result)) throw new TypeError('Please provide a valid number or percentage string e.g. "25%"');
  return result > 1 ? result / 100 : result;
}

/**
 * Useful to determine whether to show the tilde in the display
 */
function isExactMinuteRange(diffMs) {
  // 60 * 1000 = ms per minute
  return diffMs % (60 * 1000) === 0;
}