"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonGroupButtonStyles = exports._compressedButtonFocusColors = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _button = require("../../../global_styling/mixins/_button");
var _accessibility = require("../../accessibility");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "m6ysua-tooltipWrapper",
  styles: "overflow:hidden;&:has(:focus-visible){z-index:1;};label:tooltipWrapper;"
} : {
  name: "m6ysua-tooltipWrapper",
  styles: "overflow:hidden;&:has(:focus-visible){z-index:1;};label:tooltipWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1u3o7zy-hasToolTip",
  styles: "border-radius:inherit;label:hasToolTip;"
} : {
  name: "1u3o7zy-hasToolTip",
  styles: "border-radius:inherit;label:hasToolTip;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiButtonGroupButtonStyles = exports.euiButtonGroupButtonStyles = function euiButtonGroupButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var buttonSizes = (0, _button.euiButtonSizeMap)(euiThemeContext);
  var compressedButtonHeight = (0, _global_styling.mathWithUnits)([buttonSizes.s.height, euiTheme.border.width.thin], function (x, y) {
    return x - y * 6;
  });
  var selectedSelectors = '.euiButtonGroupButton-isSelected, .euiButtonGroup__tooltipWrapper-isSelected';
  var uncompressedBorderRadii = function uncompressedBorderRadii(radiusSize) {
    return "\n    border-radius: 0;\n\n    &:first-child {\n      ".concat((0, _global_styling.logicalShorthandCSS)('border-radius', "".concat(radiusSize, " 0 0 ").concat(radiusSize)), "\n    }\n\n    &:last-child {\n      ").concat((0, _global_styling.logicalShorthandCSS)('border-radius', "0 ".concat(radiusSize, " ").concat(radiusSize, " 0")), "\n    }\n\n    &:first-child:last-child {\n      ").concat((0, _global_styling.logicalShorthandCSS)('border-radius', "".concat(radiusSize)), "\n    }\n  ");
  };
  return {
    // Base
    euiButtonGroupButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', 0), " flex-shrink:1;flex-grow:0;z-index:0;&:focus-visible{z-index:2;}", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.normal, " ease-in-out,color ", euiTheme.animation.normal, " ease-in-out;}&:is(", selectedSelectors, "){", (0, _global_styling.highContrastModeStyles)(euiThemeContext, {
      forced: "\n            --highContrastHoverIndicatorColor: ".concat(euiTheme.colors.textInverse, ";\n            border: none;\n\n            /* styles the content manually instead of the button itself to preserve the system\n            focus style, as otherwise preventForcedColors() would require manual styling */\n            > [class*=\"euiButtonDisplayContent\"] {\n              ").concat((0, _global_styling.preventForcedColors)(euiThemeContext), "\n              color: ").concat(euiTheme.colors.emptyShade, ";\n              border: none;\n            }\n          ")
    }), ";};label:euiButtonGroupButton;"),
    iconOnly: {
      // used only as classname, sizes are added separately
      iconOnly: /*#__PURE__*/(0, _react.css)(";label:iconOnly;"),
      s: "\n        ".concat((0, _global_styling.logicalCSS)('width', buttonSizes.s.height), "\n      "),
      m: "\n        ".concat((0, _global_styling.logicalCSS)('width', buttonSizes.m.height), "\n      "),
      compressed: "\n        ".concat((0, _global_styling.logicalCSS)('width', compressedButtonHeight), "\n      ")
    },
    // Sizes
    uncompressed: {
      uncompressed: /*#__PURE__*/(0, _react.css)("&:focus-visible{", (0, _global_styling.euiOutline)(euiThemeContext, 'inset', euiTheme.components.buttonGroupFocusColor), ";}&:is(", selectedSelectors, "):not(", _global_styling.euiDisabledSelector, "){z-index:1;border:", euiTheme.border.width.thin, " solid transparent;", (0, _global_styling.highContrastModeStyles)(euiThemeContext, {
        forced: "\n            /* use inset focus outline to ensure visibility, same as custom hover.\n            NOTE: temp solution - this will be revisited once we handle global focus styles */\n            &:focus-visible {\n              outline-color: ".concat(euiTheme.colors.textInverse, ";\n              /* has to be inset due to overflow: hidden */\n              outline-offset: -").concat((0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
          return x * 4;
        }), ";\n            }\n          ")
      }), ";};label:uncompressed;"),
      get borders() {
        // We use pseudo elements to avoid affecing button width, and to allow
        // inheriting high contrast border colors
        var selectors = selectedSelectors;
        var selectedColor = highContrastMode ? euiTheme.colors.emptyShade : euiTheme.components.buttonGroupBorderColorSelected;
        var unselectedColor = highContrastMode ? 'inherit' : euiTheme.components.buttonGroupBorderColor;
        var borderWidth = euiTheme.border.width.thin;

        // "Borders" between buttons should be present between two of the same colored buttons,
        // and absent between selected vs non-selected buttons (different colors)
        return "\n          position: relative;\n\n          &:not(:first-child) {\n            margin-inline-start: -".concat(borderWidth, ";\n          }\n\n          &:is(").concat(selectors, ") {\n            &::before {\n              position: absolute;\n              z-index: 1;\n              ").concat((0, _global_styling.logicalCSS)('left', 0), "\n              ").concat((0, _global_styling.logicalCSS)('vertical', "-".concat(euiTheme.border.width.thin)), "\n              ").concat((0, _global_styling.logicalCSS)('border-left-style', 'solid'), "\n              ").concat((0, _global_styling.logicalCSS)('border-left-width', euiTheme.border.width.thin), "\n              pointer-events: none;\n\n              ").concat((0, _global_styling.preventForcedColors)(euiThemeContext), "\n            }\n          }\n\n          &:not(").concat(selectors, ") + *:not(").concat(selectors, ") {\n            &::before {\n              content: '';\n              border-color: ").concat(unselectedColor, ";\n            }\n          }\n\n          &:is(").concat(selectors, ") + *:is(").concat(selectors, ") {\n            &::before {\n              content: '';\n              border-color: ").concat(selectedColor, ";\n            }\n          }\n        ");
      },
      get s() {
        return /*#__PURE__*/(0, _react.css)(this.borders, " ", uncompressedBorderRadii(euiTheme.border.radius.small), ";;label:s;");
      },
      get m() {
        var radius = euiTheme.border.radius.small;
        return /*#__PURE__*/(0, _react.css)(this.borders, " ", uncompressedBorderRadii(radius), ";;label:m;");
      },
      hasToolTip: _ref2
    },
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', compressedButtonHeight), " line-height:", compressedButtonHeight, ";font-weight:", euiTheme.font.weight.medium, ";padding:0;margin:", euiTheme.size.xxs, ";border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";&+.euiButtonGroupButton{", (0, _global_styling.logicalCSS)('margin-left', '0'), ";}&:is(", selectedSelectors, "):not(:disabled){border:none;", (0, _global_styling.highContrastModeStyles)(euiThemeContext, {
      forced: "\n            /* use inset focus outline to ensure visibility, same as custom hover.\n            NOTE: temp solution - this will be revisited once we handle global focus styles */\n            &:focus-visible {\n              outline-color: ".concat(euiTheme.colors.textInverse, ";\n              /* has to be inset due to overflow: hidden */\n              outline-offset: -").concat((0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
        return x * 3;
      }), ";\n            }\n          ")
    }), ";};label:compressed;"),
    // States
    disabledAndSelected: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textDisabled, ";background-color:", euiTheme.components.buttonGroupBackgroundDisabledSelected, ";border:", highContrastMode ? "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.components.buttonGroupBackgroundDisabledSelected) : "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.borderBasePlain), ";;label:disabledAndSelected;"),
    // Skip css`` to avoid generating a className
    hasBorder: "\n      border: ".concat(euiTheme.border.width.thin, " solid\n        ").concat(euiTheme.colors.borderBasePlain, ";\n    "),
    // Tooltip anchor wrapper
    tooltipWrapper: _ref,
    // Content wrapper
    content: {
      euiButtonGroupButton__content: /*#__PURE__*/(0, _react.css)(";label:euiButtonGroupButton__content;"),
      compressed: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.s, ";;label:compressed;")
    },
    // Text wrapper
    text: {
      euiButtonGroupButton__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextShift)('bold', 'data-text', euiTheme), ";;label:euiButtonGroupButton__text;"),
      euiButtonGroupButton__iconOnly: /*#__PURE__*/(0, _react.css)((0, _accessibility.euiScreenReaderOnly)(), ";;label:euiButtonGroupButton__iconOnly;")
    }
  };
};
var _compressedButtonFocusColors = exports._compressedButtonFocusColors = function _compressedButtonFocusColors(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var colors = [].concat(_toConsumableArray(_button.BUTTON_COLORS), ['disabled']);
  return colors.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/(0, _react.css)("&:focus-visible{", (0, _global_styling.euiOutline)(euiThemeContext, 'outset', euiTheme.focus.color), ";}")));
  }, {});
};