"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOInspect = SLOInspect;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ingest-pipelines-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_fetch_slo_inspect = require("../../../../../hooks/use_fetch_slo_inspect");
var _process_slo_form_values = require("../../../helpers/process_slo_form_values");
var _code_block_accordion = require("./code_block_accordion");
var _loading_state = require("./loading_state");
var _req_code_viewer = require("./req_code_viewer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/slo_inspect/slo_inspect.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SLOInspect({
  slo,
  disabled
}) {
  var _inspectSloData$summa2, _inspectSloData$rollU2;
  const {
    share,
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    trigger,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [isFormValid, setFormValid] = (0, _react.useState)(false);
  const sloFormValues = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(getValues());
  const {
    data: inspectSloData,
    isLoading
  } = (0, _use_fetch_slo_inspect.useFetchSloInspect)({
    ...sloFormValues,
    id: slo === null || slo === void 0 ? void 0 : slo.id,
    revision: slo === null || slo === void 0 ? void 0 : slo.revision
  }, isFlyoutVisible && isFormValid);
  const {
    data: summaryPipelineUrl
  } = (0, _public2.useFetcher)(async () => {
    var _inspectSloData$summa;
    const ingestPipeLocator = share.url.locators.get(_public.INGEST_PIPELINES_APP_LOCATOR);
    const ingestPipelineId = inspectSloData === null || inspectSloData === void 0 ? void 0 : (_inspectSloData$summa = inspectSloData.summaryPipeline) === null || _inspectSloData$summa === void 0 ? void 0 : _inspectSloData$summa.id;
    return ingestPipeLocator === null || ingestPipeLocator === void 0 ? void 0 : ingestPipeLocator.getUrl({
      pipelineId: ingestPipelineId,
      page: _public.INGEST_PIPELINES_PAGES.LIST
    });
  }, [inspectSloData === null || inspectSloData === void 0 ? void 0 : (_inspectSloData$summa2 = inspectSloData.summaryPipeline) === null || _inspectSloData$summa2 === void 0 ? void 0 : _inspectSloData$summa2.id, share.url.locators]);
  const {
    data: rollUpPipelineUrl
  } = (0, _public2.useFetcher)(async () => {
    var _inspectSloData$rollU;
    const ingestPipeLocator = share.url.locators.get(_public.INGEST_PIPELINES_APP_LOCATOR);
    const ingestPipelineId = inspectSloData === null || inspectSloData === void 0 ? void 0 : (_inspectSloData$rollU = inspectSloData.rollUpPipeline) === null || _inspectSloData$rollU === void 0 ? void 0 : _inspectSloData$rollU.id;
    return ingestPipeLocator === null || ingestPipeLocator === void 0 ? void 0 : ingestPipeLocator.getUrl({
      pipelineId: ingestPipelineId,
      page: _public.INGEST_PIPELINES_PAGES.LIST
    });
  }, [inspectSloData === null || inspectSloData === void 0 ? void 0 : (_inspectSloData$rollU2 = inspectSloData.rollUpPipeline) === null || _inspectSloData$rollU2 === void 0 ? void 0 : _inspectSloData$rollU2.id, share.url.locators]);
  const closeFlyout = () => {
    setIsFlyoutVisible(false);
    setFormValid(false);
  };
  const handleInspectButtonClick = async () => {
    const valid = await trigger();
    if (!valid) {
      setFormValid(false);
      return;
    }
    setFormValid(true);
    setIsFlyoutVisible(true);
  };
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      onClose: closeFlyout,
      "aria-labelledby": "flyoutTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "flyoutTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.monitorInspect.configLabel', {
      defaultMessage: 'SLO Configurations'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }, isLoading && /*#__PURE__*/_react.default.createElement(_loading_state.LoadingState, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 25
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }), inspectSloData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "slo",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.sloConfigurationLabel', {
        defaultMessage: 'SLO configuration'
      }),
      json: inspectSloData.slo,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "rollUpTransform",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.rollupTransformLabel', {
        defaultMessage: 'Rollup transform'
      }),
      json: inspectSloData.rollUpTransform,
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/data/transform'),
        "aria-label": _i18n.i18n.translate('xpack.slo.sLOInspect.viewRollupTransformButtonAriaLabel', {
          defaultMessage: 'View rollup transform'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "summaryTransform",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.summaryTransformLabel', {
        defaultMessage: 'Summary transform'
      }),
      json: inspectSloData.summaryTransform,
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/data/transform'),
        "aria-label": _i18n.i18n.translate('xpack.slo.sLOInspect.viewSummaryTransformButtonAriaLabel', {
          defaultMessage: 'View summary transform'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "rollupPipeline",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.rollupIngestPipelineLabel', {
        defaultMessage: 'Rollup ingest pipeline'
      }),
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: rollUpPipelineUrl,
        "aria-label": _i18n.i18n.translate('xpack.slo.sLOInspect.viewRollupPipelineButtonAriaLabel', {
          defaultMessage: 'View rollup ingest pipeline'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 19
        }
      }),
      json: inspectSloData.rollUpPipeline,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "summaryPipeline",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.summaryIngestPipelineLabel', {
        defaultMessage: 'Summary ingest pipeline'
      }),
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: summaryPipelineUrl,
        "aria-label": _i18n.i18n.translate('xpack.slo.sLOInspect.viewSummaryPipelineButtonAriaLabel', {
          defaultMessage: 'View summary ingest pipeline'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 19
        }
      }),
      json: inspectSloData.summaryPipeline,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "temporaryDoc",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.temporaryDocumentLabel', {
        defaultMessage: 'Temporary document'
      }),
      json: inspectSloData.temporaryDoc,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "rollupTransformQuery",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.transformQueryLabel', {
        defaultMessage: 'Rollup Transform query composite'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_req_code_viewer.RequestCodeViewer, {
      value: inspectSloData.rollUpTransformCompositeQuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_code_block_accordion.CodeBlockAccordion, {
      id: "summmaryTransformQuery",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.summaryTransformQueryLabel', {
        defaultMessage: 'Summary Transform query composite'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_req_code_viewer.RequestCodeViewer, {
      value: inspectSloData.summaryTransformCompositeQuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMonitorInspectCloseButton",
      onClick: closeFlyout,
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.sLOInspect.closeButtonLabel', {
      defaultMessage: 'Close'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isFormValid ? _i18n.i18n.translate('xpack.slo.viewFormattedResourcesConfigsButtonLabel', {
      defaultMessage: 'View formatted resources configs for SLO'
    }) : _i18n.i18n.translate('xpack.slo.formattedConfigLabel.valid', {
      defaultMessage: 'Only valid form configurations can be inspected.'
    }),
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "syntheticsMonitorInspectShowFlyoutExampleButton",
    onClick: handleInspectButtonClick,
    disabled: disabled,
    iconType: "inspect",
    iconSide: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.sLOInspect.sLOInspectButtonLabel', {
    defaultMessage: 'SLO Inspect'
  }))), flyout);
}