"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedTab = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _slo_details = require("../components/slo_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectedTab = () => {
  const {
    tabId
  } = (0, _reactRouterDom.useParams)();
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(() => {
    return tabId && [_slo_details.OVERVIEW_TAB_ID, _slo_details.ALERTS_TAB_ID, _slo_details.HISTORY_TAB_ID].includes(tabId) ? tabId : _slo_details.OVERVIEW_TAB_ID;
  });
  (0, _react.useEffect)(() => {
    // update the url when the selected tab changes
    if (tabId !== selectedTabId) {
      setSelectedTabId(tabId);
    }
  }, [selectedTabId, tabId]);
  return {
    selectedTabId: selectedTabId || _slo_details.OVERVIEW_TAB_ID,
    setSelectedTabId
  };
};
exports.useSelectedTab = useSelectedTab;