"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloDefinitions = useFetchSloDefinitions;
var _reactQuery = require("@kbn/react-query");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloDefinitions({
  name = '',
  includeOutdatedOnly = false,
  tags = [],
  page = 1,
  perPage = 100,
  includeHealth = false
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const search = name.endsWith('*') ? name : `${name}*`;
  const validTags = tags.filter(tag => !!tag).join();
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.definitions({
      search,
      page,
      perPage,
      includeOutdatedOnly,
      validTags
    }),
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch('GET /api/observability/slos/_definitions 2023-10-31', {
          params: {
            query: {
              ...(search !== undefined && {
                search
              }),
              ...(!!includeOutdatedOnly && {
                includeOutdatedOnly
              }),
              ...(!!includeHealth && {
                includeHealth
              }),
              ...((validTags === null || validTags === void 0 ? void 0 : validTags.length) && {
                tags: validTags
              }),
              ...(page !== undefined && {
                page: String(page)
              }),
              ...(perPage !== undefined && {
                perPage: String(perPage)
              })
            }
          },
          signal
        });
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    },
    retry: false,
    refetchOnWindowFocus: false
  });
  return {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  };
}