"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorBudgetEmbeddableFactory = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _plugin_context = require("../../../context/plugin_context");
var _constants = require("./constants");
var _error_budget_burn_down = require("./error_budget_burn_down");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/error_budget/error_budget_react_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getErrorBudgetPanelTitle = () => _i18n.i18n.translate('xpack.slo.errorBudgetEmbeddable.title', {
  defaultMessage: 'SLO Error Budget burn down'
});
const getErrorBudgetEmbeddableFactory = ({
  coreStart,
  pluginsStart,
  sloClient
}) => {
  const factory = {
    type: _constants.SLO_ERROR_BUDGET_ID,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const deps = {
        ...coreStart,
        ...pluginsStart
      };
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const defaultTitle$ = new _rxjs.BehaviorSubject(getErrorBudgetPanelTitle());
      const sloErrorBudgetManager = (0, _presentationPublishing.initializeStateManager)(initialState.rawState, {
        sloId: undefined,
        sloInstanceId: undefined
      });
      const reload$ = new _rxjs.Subject();
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...sloErrorBudgetManager.getLatestState()
          }
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, sloErrorBudgetManager.anyStateChange$),
        getComparators: () => ({
          ..._presentationPublishing.titleComparators,
          sloId: 'referenceEquality',
          sloInstanceId: 'referenceEquality'
        }),
        onReset: lastState => {
          sloErrorBudgetManager.reinitializeState(lastState === null || lastState === void 0 ? void 0 : lastState.rawState);
          titleManager.reinitializeState(lastState === null || lastState === void 0 ? void 0 : lastState.rawState);
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...unsavedChangesApi,
        defaultTitle$,
        serializeState
      });
      const fetchSubscription = (0, _presentationPublishing.fetch$)(api).pipe().subscribe(next => {
        reload$.next(next.isReload);
      });
      return {
        api,
        Component: () => {
          const [sloId, sloInstanceId] = (0, _presentationPublishing.useBatchedPublishingSubjects)(sloErrorBudgetManager.api.sloId$, sloErrorBudgetManager.api.sloInstanceId$);
          (0, _react.useEffect)(() => {
            return () => {
              fetchSubscription.unsubscribe();
            };
          }, []);
          const queryClient = new _reactQuery.QueryClient();
          return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
            services: deps,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 116,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
            value: {
              observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
              ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
              sloClient
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 117,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
            client: queryClient,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_error_budget_burn_down.SloErrorBudget, {
            sloId: sloId,
            sloInstanceId: sloInstanceId,
            reloadSubject: reload$,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 127,
              columnNumber: 19
            }
          }))));
        }
      };
    }
  };
  return factory;
};
exports.getErrorBudgetEmbeddableFactory = getErrorBudgetEmbeddableFactory;