"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsTable = SloAlertsTable;
exports.useSloAlertsQuery = exports.getSloInstanceFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _public = require("@kbn/observability-plugin/public");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/alerts/components/slo_alerts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERTS_PER_PAGE = 10;
const ALERTS_TABLE_ID = 'xpack.observability.sloAlertsEmbeddable.alert.table';
/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const columns = [{
  displayAsText: _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.alertsTGrid.statusColumnDescription', {
    defaultMessage: 'Status'
  }),
  id: _ruleDataUtils.ALERT_STATUS,
  initialWidth: 110
}, {
  displayAsText: _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.alertsTGrid.durationColumnDescription', {
    defaultMessage: 'Duration'
  }),
  id: _ruleDataUtils.ALERT_DURATION,
  initialWidth: 116
}, {
  displayAsText: _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.alertsTGrid.sloColumnDescription', {
    defaultMessage: 'Rule name'
  }),
  id: _ruleDataUtils.ALERT_RULE_NAME,
  initialWidth: 110
}, {
  displayAsText: _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.alertsTGrid.reasonColumnDescription', {
    defaultMessage: 'Reason'
  }),
  id: _ruleDataUtils.ALERT_REASON
}];
const getSloInstanceFilter = (sloId, sloInstanceId, showAllGroupByInstances = false) => {
  return {
    bool: {
      must: [{
        term: {
          'slo.id': sloId
        }
      }, ...(sloInstanceId !== _sloSchema.ALL_VALUE && !showAllGroupByInstances ? [{
        term: {
          'slo.instanceId': sloInstanceId
        }
      }] : [])]
    }
  };
};
exports.getSloInstanceFilter = getSloInstanceFilter;
const useSloAlertsQuery = (slos, timeRange, showAllGroupByInstances) => {
  return (0, _react.useMemo)(() => {
    const query = {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: timeRange.from
            }
          }
        }, {
          term: {
            'kibana.alert.rule.rule_type_id': 'slo.rules.burnRate'
          }
        }, {
          bool: {
            should: slos.map(slo => getSloInstanceFilter(slo.id, slo.instanceId, showAllGroupByInstances))
          }
        }]
      }
    };
    return query;
  }, [showAllGroupByInstances, slos, timeRange.from]);
};
exports.useSloAlertsQuery = useSloAlertsQuery;
function SloAlertsTable({
  deps: {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings
  },
  slos,
  timeRange,
  onLoaded,
  lastReloadRequestTime,
  showAllGroupByInstances
}) {
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _ref$current;
    (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.refresh();
  }, [lastReloadRequestTime]);
  return /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertsTable, {
    ref: ref,
    id: ALERTS_TABLE_ID,
    ruleTypeIds: [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID],
    consumers: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    query: useSloAlertsQuery(slos, timeRange, showAllGroupByInstances),
    columns: columns,
    hideLazyLoader: true,
    pageSize: ALERTS_PER_PAGE,
    onLoaded: () => {
      if (onLoaded) {
        onLoaded();
      }
    },
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      cases,
      settings
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  });
}