"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomAlertDetailsPanel = CustomAlertDetailsPanel;
var _react = _interopRequireDefault(require("react"));
var _apm_alert_details = require("./apm/apm_alert_details");
var _custom_kql_panels = require("./custom_kql/custom_kql_panels");
var _time_range = require("../../utils/time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/alert_details/components/custom_panels/custom_panels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CustomAlertDetailsPanel({
  slo,
  alert,
  rule
}) {
  const dataTimeRange = (0, _time_range.getDataTimeRange)(alert);
  switch (slo === null || slo === void 0 ? void 0 : slo.indicator.type) {
    case 'sli.kql.custom':
      return /*#__PURE__*/_react.default.createElement(_custom_kql_panels.CustomKqlPanels, {
        slo: slo,
        alert: alert,
        rule: rule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 14
        }
      });
    case 'sli.apm.transactionDuration':
      return /*#__PURE__*/_react.default.createElement(_apm_alert_details.APMLatencyAlertDetails, {
        slo: slo,
        dataTimeRange: dataTimeRange,
        alert: alert,
        rule: rule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 9
        }
      });
    case 'sli.apm.transactionErrorRate':
      return /*#__PURE__*/_react.default.createElement(_apm_alert_details.APMAvailabilityAlertDetails, {
        slo: slo,
        dataTimeRange: dataTimeRange,
        alert: alert,
        rule: rule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      });
    default:
      return null;
  }
}