"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextHighlight = void 0;
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/process_tree_node/text_highlight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const css = {
  '&&': {
    display: 'inline',
    fontSize: 0,
    lineHeight: 0
  }
};
// Component that takes an array of matching indices in a text and pass down a highlight
// css style prop across its children
// Currently it works only for a single child level, designed to be in combination with SplitText
// It adds a `aria-label` attribute to a parent span, which is used by screen readers to
// read the text as a single block.
const TextHighlight = ({
  children,
  match,
  text,
  highlightStyle
}) => {
  let startIdx = 0;
  return /*#__PURE__*/_react.default.createElement("span", {
    css: css,
    "aria-label": text,
    role: "document",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, !match ? children : _react.default.Children.map(children, child => {
    const childText = child.props.children;
    const childTextLength = childText.length;
    const highlightIndices = match.map(v => v - startIdx);
    startIdx += childTextLength;
    return /*#__PURE__*/_react.default.cloneElement(child, {
      highlightIndices,
      highlightStyle
    });
  }));
};
exports.TextHighlight = TextHighlight;