"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputButton = exports.OUTPUT = exports.ChildrenProcessesButton = exports.CHILD_PROCESSES = exports.AlertButton = exports.ALERTS = exports.ALERT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_button_styles = require("./use_button_styles");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/process_tree_node/buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_ALERT_COUNT = 99;
const CHILD_PROCESSES = exports.CHILD_PROCESSES = _i18n.i18n.translate('xpack.sessionView.childProcesses', {
  defaultMessage: 'Child processes'
});
const ALERTS = exports.ALERTS = _i18n.i18n.translate('xpack.sessionView.alerts', {
  defaultMessage: 'Alerts'
});
const ALERT = exports.ALERT = _i18n.i18n.translate('xpack.sessionView.alert', {
  defaultMessage: 'Alert'
});
const OUTPUT = exports.OUTPUT = _i18n.i18n.translate('xpack.sessionView.output', {
  defaultMessage: 'Output'
});
const ChildrenProcessesButton = ({
  onToggle,
  isExpanded
}) => {
  const {
    button,
    buttonArrow
  } = (0, _use_button_styles.useButtonStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: isExpanded ? 'isExpanded' : '',
    key: "child-processes-button",
    css: button,
    onClick: onToggle,
    "data-test-subj": "sessionView:processTreeNodeChildProcessesButton",
    "aria-label": CHILD_PROCESSES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, CHILD_PROCESSES, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: buttonArrow,
    size: "s",
    type: "arrowDown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.ChildrenProcessesButton = ChildrenProcessesButton;
const AlertButton = ({
  isExpanded,
  alertTypeCounts,
  onToggle,
  alertsCount
}) => {
  const {
    alertButton,
    buttonArrow
  } = (0, _use_button_styles.useButtonStyles)();
  const alertIcons = (0, _react.useMemo)(() => {
    var _alertTypeCounts$filt;
    return alertTypeCounts === null || alertTypeCounts === void 0 ? void 0 : (_alertTypeCounts$filt = alertTypeCounts.filter(alertTypeCount => alertTypeCount.count > 0)) === null || _alertTypeCounts$filt === void 0 ? void 0 : _alertTypeCounts$filt.map(({
      category
    }, i) => _constants.ALERT_ICONS[category]);
  }, [alertTypeCounts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: isExpanded ? 'isExpanded' : '',
    key: "alert-button",
    css: alertButton,
    onClick: onToggle,
    "data-test-subj": "processTreeNodeAlertButton",
    "aria-label": ALERTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, alertsCount > 1 ? ALERTS : ALERT, alertsCount > 1 && (alertsCount > MAX_ALERT_COUNT ? ` (${MAX_ALERT_COUNT}+)` : ` (${alertsCount})`), alertIcons === null || alertIcons === void 0 ? void 0 : alertIcons.map((icon, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "alertIcon",
    key: `${icon}-${index}`,
    size: "s",
    type: icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: buttonArrow,
    size: "s",
    type: "arrowDown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
};
exports.AlertButton = AlertButton;
const OutputButton = ({
  onClick
}) => {
  const {
    outputButton,
    buttonArrow
  } = (0, _use_button_styles.useButtonStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "output-button",
    css: outputButton,
    onClick: onClick,
    "data-test-subj": "processTreeNodeOutpuButton",
    "aria-label": OUTPUT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, OUTPUT, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: buttonArrow,
    size: "s",
    type: "arrowRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }));
};
exports.OutputButton = OutputButton;