"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorPrivilegesCallout = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_connectors = require("../../../hooks/api/use_connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/connector_config/connector_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectorPrivilegesCallout = () => {
  const {
    data
  } = (0, _use_connectors.useConnectors)();
  if (!data || data.canManageConnectors && data.canReadConnectors) {
    return null;
  }
  const calloutTitle = _i18n.i18n.translate('xpack.serverlessSearch.connectors.noPrivilegesTitle', {
    defaultMessage: 'Insufficient access'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutTitle,
    color: "warning",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, data.canReadConnectors ? _i18n.i18n.translate('xpack.serverlessSearch.connectors.noManagePrivileges', {
    defaultMessage: 'You have read-only access to connectors. Contact your administrator for elevated privileges.'
  }) : _i18n.i18n.translate('xpack.serverlessSearch.connectors.noPrivileges', {
    defaultMessage: "You don't have access to connectors. Contact your administrator for access."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }));
};
exports.ConnectorPrivilegesCallout = ConnectorPrivilegesCallout;