"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableRuleActions = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _connectorSchemas = require("@kbn/connector-schemas");
var _config = require("@kbn/actions-plugin/server/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTERNAL_RULE_ACTIONS = [_connectorSchemas.EsIndexConnectorTypeId, _connectorSchemas.SlackWebhookConnectorTypeId, _connectorSchemas.EmailConnectorTypeId];

/**
 * enable rule actions based on ProductFeature Config
 */
const enableRuleActions = ({
  actions,
  productFeatureKeys
}) => {
  if (productFeatureKeys.includes(_keys.ProductFeatureSecurityKey.externalRuleActions)) {
    // enables all rule actions
    actions.setEnabledConnectorTypes([_config.EnabledActionTypes.Any]);
  } else {
    actions.setEnabledConnectorTypes(INTERNAL_RULE_ACTIONS);
  }
};
exports.enableRuleActions = enableRuleActions;