"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCloudLink = exports.getProjectId = exports.getProjectFeaturesUrl = exports.getCloudUrl = exports.getCloudLinkKey = void 0;
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isCloudLink = linkId => linkId.startsWith('cloud:');
exports.isCloudLink = isCloudLink;
const getCloudLinkKey = linkId => linkId.replace('cloud:', '');
exports.getCloudLinkKey = getCloudLinkKey;
const getProjectId = cloud => {
  var _cloud$serverless;
  return (_cloud$serverless = cloud.serverless) === null || _cloud$serverless === void 0 ? void 0 : _cloud$serverless.projectId;
};
exports.getProjectId = getProjectId;
const getProjectFeaturesUrl = cloud => {
  const projectsBaseUrl = getCloudUrl('projects', cloud);
  const projectId = getProjectId(cloud);
  if (!projectsBaseUrl || !projectId) {
    return undefined;
  }
  return `${projectsBaseUrl}${_common.SECURITY_PROJECT_TYPE}/${projectId}?open=securityProjectFeatures`;
};
exports.getProjectFeaturesUrl = getProjectFeaturesUrl;
const getCloudUrl = (cloudUrlKey, cloud) => {
  const cloudUrls = cloud.getUrls();
  switch (cloudUrlKey) {
    case 'deployment':
      return cloudUrls.deploymentUrl;
    case 'organization':
      return cloudUrls.organizationUrl;
    case 'performance':
      return cloudUrls.performanceUrl;
    case 'profile':
      return cloudUrls.profileUrl;
    case 'usersAndRoles':
      return cloudUrls.usersAndRolesUrl;
    case 'projects':
      return cloudUrls.projectsUrl;
    default:
      return undefined;
  }
};
exports.getCloudUrl = getCloudUrl;