"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationTree = void 0;
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("@kbn/security-solution-navigation/links");
var _navigation_tree = require("@kbn/security-solution-navigation/navigation_tree");
var _stack_management_navigation = require("./stack_management_navigation");
var _v2_footer_items = require("./v2_footer_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolutionServerless.navLinks.projectType.title', {
  defaultMessage: 'Security'
});
const createNavigationTree = async services => {
  return {
    body: [{
      type: 'navGroup',
      id: 'security_solution_nav',
      title: SOLUTION_NAME,
      icon: 'logoSecurity',
      breadcrumbStatus: 'hidden',
      isCollapsible: false,
      defaultIsCollapsed: false,
      children: [{
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
        title: SOLUTION_NAME,
        icon: 'logoSecurity',
        renderAs: 'home',
        sideNavVersion: 'v2'
      }, {
        link: 'discover',
        sideNavVersion: 'v1'
      }, _navigation_tree.defaultNavigationTree.dashboards({
        sideNavVersion: 'v1'
      }), {
        breadcrumbStatus: 'hidden',
        children: [_navigation_tree.defaultNavigationTree.rules({
          sideNavVersion: 'v1'
        }), services.featureFlags.getBooleanValue(_securitySolutionNavigation.ATTACKS_ALERTS_ALIGNMENT_ENABLED, false) ? _navigation_tree.defaultNavigationTree.alertDetections({
          sideNavVersion: 'v1'
        }) : {
          id: _securitySolutionNavigation.SecurityPageName.alerts,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.alerts),
          sideNavVersion: 'v1'
        }, {
          link: 'workflows',
          withBadge: true,
          badgeTypeV2: 'techPreview',
          badgeOptions: {
            icon: 'beaker',
            tooltip: _links.i18nStrings.workflows.badgeTooltip
          },
          sideNavVersion: 'v1'
        }, {
          id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery),
          sideNavVersion: 'v1'
        }, {
          id: _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings),
          sideNavVersion: 'v1'
        }, _navigation_tree.defaultNavigationTree.cases({
          sideNavVersion: 'v1'
        })]
      }, {
        breadcrumbStatus: 'hidden',
        children: [_navigation_tree.defaultNavigationTree.entityAnalytics({
          sideNavVersion: 'v1'
        }), _navigation_tree.defaultNavigationTree.explore({
          sideNavVersion: 'v1'
        }), _navigation_tree.defaultNavigationTree.investigations({
          sideNavVersion: 'v1'
        }), {
          id: _securitySolutionNavigation.SecurityPageName.threatIntelligence,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.threatIntelligence),
          sideNavVersion: 'v1'
        }]
      }, {
        breadcrumbStatus: 'hidden',
        children: [{
          id: _securitySolutionNavigation.SecurityPageName.assetInventory,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.assetInventory),
          sideNavVersion: 'v1'
        }, _navigation_tree.defaultNavigationTree.assets(services, {
          sideNavVersion: 'v1'
        }), {
          id: _securitySolutionNavigation.SecurityPageName.siemReadiness,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemReadiness),
          sideNavVersion: 'v1'
        }]
      }, _navigation_tree.defaultNavigationTree.ml({
        sideNavVersion: 'v1'
      }),
      // version 2 sidenav
      ..._navigation_tree.defaultNavigationTree.v2(services)]
    }],
    footer: [{
      id: 'security_solution_nav_footer',
      type: 'navGroup',
      children: [{
        id: _securitySolutionNavigation.SecurityGroupName.launchpad,
        title: _links.SecurityLinkGroup[_securitySolutionNavigation.SecurityGroupName.launchpad].title,
        renderAs: 'panelOpener',
        sideNavVersion: 'v1',
        iconV2: 'launch',
        children: [{
          children: [{
            id: _securitySolutionNavigation.SecurityPageName.landing,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
            sideNavVersion: 'v1'
          }, {
            // value report
            id: _securitySolutionNavigation.SecurityPageName.aiValue,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.aiValue),
            sideNavVersion: 'v1'
          }]
        }]
      }, {
        id: _securitySolutionNavigation.SecurityGroupName.launchpad,
        title: _links.i18nStrings.launchPad.title,
        renderAs: 'panelOpener',
        sideNavVersion: 'v2',
        iconV2: 'launch',
        children: [{
          children: [{
            id: _securitySolutionNavigation.SecurityPageName.landing,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
            sideNavVersion: 'v2'
          }, {
            id: _securitySolutionNavigation.SecurityPageName.siemReadiness,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemReadiness),
            sideNavVersion: 'v2'
          }, {
            // value report
            id: _securitySolutionNavigation.SecurityPageName.aiValue,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.aiValue),
            sideNavVersion: 'v2'
          }]
        }, {
          title: _links.i18nStrings.launchPad.migrations.title,
          children: [{
            id: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemMigrationsRules),
            sideNavVersion: 'v2'
          }, {
            id: _securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards),
            sideNavVersion: 'v2'
          }]
        }]
      }, {
        link: 'dev_tools',
        title: _links.i18nStrings.devTools,
        icon: 'editorCodeBlock'
      }, (0, _stack_management_navigation.createStackManagementNavigationTree)({
        sideNavVersion: 'v1'
      }), (0, _v2_footer_items.createV2footerItemsTree)()]
    }]
  };
};
exports.createNavigationTree = createNavigationTree;