"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveTimelineRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../common/constants");
var _utils = require("../../../../detection_engine/routes/utils");
var _common = require("../../../utils/common");
var _timeline = require("../../../../../../common/api/timeline");
var _timelines = require("../../../saved_object/timelines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolveTimelineRoute = router => {
  router.versioned.get({
    path: _constants.TIMELINE_RESOLVE_URL,
    security: {
      authz: {
        requiredPrivileges: ['timeline_read']
      }
    },
    access: 'public'
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_timeline.ResolveTimelineRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _request$query;
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
      const query = (_request$query = request.query) !== null && _request$query !== void 0 ? _request$query : {};
      const {
        template_timeline_id: templateTimelineId,
        id
      } = query;
      if (templateTimelineId != null && id == null) {
        // Template timelineId is not a SO id, so it does not need to be updated to use resolve
        const timeline = await (0, _timelines.getTimelineTemplateOrNull)(frameworkRequest, templateTimelineId);
        if (timeline) {
          return response.ok({
            body: {
              timeline,
              outcome: 'exactMatch'
            }
          });
        }
      } else if (templateTimelineId == null && id != null) {
        // In the event the objectId is defined, run the resolve call
        const timelineOrNull = await (0, _timelines.resolveTimelineOrNull)(frameworkRequest, id);
        if (timelineOrNull) {
          return response.ok({
            body: timelineOrNull
          });
        }
      } else {
        throw new Error('please provide id or template_timeline_id');
      }
      return siemResponse.error({
        statusCode: 404,
        body: 'Could not resolve timeline'
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.resolveTimelineRoute = resolveTimelineRoute;