"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesByNameGetter = void 0;
exports.getRulesByNameTool = getRulesByNameTool;
var _tools = require("@langchain/core/tools");
var z = _interopRequireWildcard(require("@kbn/zod"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME = 'getRulesByName';
const DESCRIPTION = 'Retrieves and returns rules by their names. Input should be a list of rule names';
const SCHEMA = z.object({
  names: z.array(z.string()).describe('A list of rule names to retrieve')
});
const getRulesByNameGetter = (migrationId, rulesClient) => async ({
  names
}) => {
  const response = await rulesClient.items.getByQuery(migrationId, {
    queryDSL: {
      terms: {
        'original_rule.title.keyword': names
      }
    }
  });
  return response.data.map(item => item.original_rule.query);
};
exports.getRulesByNameGetter = getRulesByNameGetter;
function getRulesByNameTool(migrationId, rulesClient) {
  return {
    [NAME]: (0, _tools.tool)(getRulesByNameGetter(migrationId, rulesClient), {
      name: NAME,
      description: DESCRIPTION,
      schema: SCHEMA
    })
  };
}