"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsStopRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/siem_migrations/constants");
var _rule_migration = require("../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _audit = require("../../common/api/util/audit");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _with_existing_migration_id = require("../../common/api/util/with_existing_migration_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsStopRoute = (router, logger) => {
  router.versioned.post({
    path: _constants.SIEM_RULE_MIGRATION_STOP_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.StopRuleMigrationRequestParams)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'rules');
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      const {
        exists,
        stopped
      } = await ruleMigrationsClient.task.stop(migrationId);
      if (!exists) {
        return res.notFound();
      }
      await siemMigrationAuditLogger.logStop({
        migrationId
      });
      return res.ok({
        body: {
          stopped
        }
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logStop({
        migrationId,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  })));
};
exports.registerSiemRuleMigrationsStopRoute = registerSiemRuleMigrationsStopRoute;