"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsResourceGetMissingRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_migration = require("../../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _constants = require("../../../../../../common/siem_migrations/constants");
var _authz = require("../../../common/api/util/authz");
var _with_license = require("../../../common/api/util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsResourceGetMissingRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATION_RESOURCES_MISSING_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.GetRuleMigrationResourcesMissingRequestParams)
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      const options = {
        filters: {
          hasContent: false
        }
      };
      const batches = ruleMigrationsClient.data.resources.searchBatches(migrationId, options);
      const missingResources = [];
      let results = await batches.next();
      while (results.length) {
        missingResources.push(...results.map(({
          type,
          name
        }) => ({
          type,
          name
        })));
        results = await batches.next();
      }
      return res.ok({
        body: missingResources
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsResourceGetMissingRoute = registerSiemRuleMigrationsResourceGetMissingRoute;