"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationsRetriever = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dashboard_resource_retriever = require("./dashboard_resource_retriever");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * DashboardMigrationsRetriever is a class that is responsible for retrieving all the necessary data during the dashboard migration process.
 * It is composed of multiple retrievers that are responsible for retrieving specific types of data.
 * Such as dashboard integrations, prebuilt dashboards, and dashboard resources.
 */
class DashboardMigrationsRetriever {
  constructor(migrationId, clients) {
    (0, _defineProperty2.default)(this, "resources", void 0);
    this.resources = new _dashboard_resource_retriever.DashboardResourceRetriever(migrationId, clients.data.resources);
  }
  async initialize() {
    await this.resources.initialize();
  }
}
exports.DashboardMigrationsRetriever = DashboardMigrationsRetriever;