"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installScriptsLibraryIndexTemplates = void 0;
var _index_template = require("./index_template");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installScriptsLibraryIndexTemplates = async ({
  esClient,
  logger
}) => {
  logger.debug('Installing/updating scripts library ES index templates');
  await esClient.indices.putIndexTemplate(_index_template.ScriptsFileMetadataIndexTemplate).catch(_utils.catchAndWrapError);
  await esClient.indices.putIndexTemplate(_index_template.ScriptsFileDataIndexTemplate).catch(_utils.catchAndWrapError);
};
exports.installScriptsLibraryIndexTemplates = installScriptsLibraryIndexTemplates;