"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddAlertsOnlyFilter = void 0;
var _react = require("react");
var _popularize_field = require("@kbn/unified-data-table/src/utils/popularize_field");
var _public = require("@kbn/data-plugin/public");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _use_data_view = require("../../../../../../data_view_manager/hooks/use_data_view");
var _kibana = require("../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../common/constants");
var _use_space_id = require("../../../../../../common/hooks/use_space_id");
var _constants2 = require("../../../../../../data_view_manager/constants");
var _store = require("../../../../../store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_ONLY_FILTER_ALIAS = _i18n.i18n.translate('xpack.securitySolution.timeline.filters.alertsOnlyFilterAlias', {
  defaultMessage: 'Alerts only'
});

/**
 * Hook to add an "alerts only" filter to a timeline's filter manager.
 */

const useAddAlertsOnlyFilter = ({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timelineDataService: {
      query: {
        filterManager
      }
    },
    dataViews,
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    dataView
  } = (0, _use_data_view.useDataView)(_constants2.PageScope.timeline);
  const spaceId = (0, _use_space_id.useSpaceId)();
  return (0, _react.useCallback)(() => {
    if (dataView && filterManager && spaceId) {
      const field = '_index';
      const operation = '+';
      const alertsIndexValue = `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`;
      // Generate filter for the alerts index
      const newFilters = (0, _public.generateFilters)(filterManager, field, alertsIndexValue, operation, dataView);
      // Alias the filter to 'Alerts only' for better UX
      newFilters[0].meta.alias = ALERTS_ONLY_FILTER_ALIAS;

      // With the new filter, we should reset the saved timeline indices to be the full data view indices
      // This reset logic typically happened here: x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/index.tsx
      if (dataView !== null && dataView !== void 0 && dataView.id) {
        dispatch(_store.timelineActions.updateDataView({
          dataViewId: dataView.id,
          id: timelineId,
          indexNames: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern().split(',')) || []
        }));
      }

      // Add the new alerts only filter
      filterManager.addFilters(newFilters);

      // Popularize the _index field since the user is explicitly filtering on it in the unified field list in timeline
      (0, _popularize_field.popularizeField)(dataView, field, dataViews, capabilities);
    }
  }, [capabilities, dataView, dataViews, dispatch, filterManager, spaceId, timelineId]);
};
exports.useAddAlertsOnlyFilter = useAddAlertsOnlyFilter;