"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEventBuildingBlockType = exports.isEvenEqlSequence = exports.getEventType = exports.NOTE_CONTENT_CLASS_NAME = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isEventBuildingBlockType = event => {
  var _event$kibana, _event$kibana$alert;
  return !(0, _fp.isEmpty)((_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : (_event$kibana$alert = _event$kibana.alert) === null || _event$kibana$alert === void 0 ? void 0 : _event$kibana$alert.building_block_type);
};
exports.isEventBuildingBlockType = isEventBuildingBlockType;
const isEvenEqlSequence = event => {
  var _event$eql;
  if (!(0, _fp.isEmpty)((_event$eql = event.eql) === null || _event$eql === void 0 ? void 0 : _event$eql.sequenceNumber)) {
    try {
      var _event$eql$sequenceNu, _event$eql2;
      const sequenceNumber = ((_event$eql$sequenceNu = (_event$eql2 = event.eql) === null || _event$eql2 === void 0 ? void 0 : _event$eql2.sequenceNumber) !== null && _event$eql$sequenceNu !== void 0 ? _event$eql$sequenceNu : '').split('-')[0];
      return parseInt(sequenceNumber, 10) % 2 === 0;
    } catch {
      return false;
    }
  }
  return false;
};
/** Return eventType raw or signal or eql */
exports.isEvenEqlSequence = isEvenEqlSequence;
const getEventType = event => {
  var _event$eql3, _event$kibana2, _event$kibana2$alert, _event$kibana2$alert$;
  if (!(0, _fp.isEmpty)(event === null || event === void 0 ? void 0 : (_event$eql3 = event.eql) === null || _event$eql3 === void 0 ? void 0 : _event$eql3.parentId)) {
    return 'eql';
  } else if (!(0, _fp.isEmpty)(event === null || event === void 0 ? void 0 : (_event$kibana2 = event.kibana) === null || _event$kibana2 === void 0 ? void 0 : (_event$kibana2$alert = _event$kibana2.alert) === null || _event$kibana2$alert === void 0 ? void 0 : (_event$kibana2$alert$ = _event$kibana2$alert.rule) === null || _event$kibana2$alert$ === void 0 ? void 0 : _event$kibana2$alert$.uuid)) {
    return 'signal';
  }
  return 'raw';
};
exports.getEventType = getEventType;
const NOTE_CONTENT_CLASS_NAME = exports.NOTE_CONTENT_CLASS_NAME = 'note-content';