"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToBlockListContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_set_url_params = require("../../../../management/components/artifact_list_page/hooks/use_set_url_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/block_list/components/add_to_block_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Add to blocklist functionality displayed as a ContextMenuItem (in the main indicators table row and in the indicator flyout).
 * The entry is disabled is the filehash isn't sha256, sha1 or md5.
 * When clicking on the ContextMenuItem, the indicator filehash value is saved in context.
 * The flyout is shown by adding a parameter to the url.
 */
const AddToBlockListContextMenu = exports.AddToBlockListContextMenu = /*#__PURE__*/(0, _react.memo)(({
  data,
  'data-test-subj': dataTestSub,
  onClick,
  setBlockListIndicatorValue
}) => {
  const canWriteBlocklist = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canWriteBlocklist;
  const setUrlParams = (0, _use_set_url_params.useSetUrlParams)();
  const menuItemClicked = (0, _react.useCallback)(() => {
    onClick();
    setBlockListIndicatorValue(data);
    setUrlParams({
      show: 'create'
    });
  }, [data, onClick, setBlockListIndicatorValue, setUrlParams]);
  const disabled = !canWriteBlocklist || data === null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    onClick: menuItemClicked,
    "data-test-subj": dataTestSub,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Add blocklist entry",
    id: "xpack.securitySolution.threatIntelligence.addToBlockList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }));
});
AddToBlockListContextMenu.displayName = 'AddToBlockListContextMenu';