"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourcererScopes = exports.sourcererScopeSelectedPatterns = exports.sourcererScopeSelectedDataViewId = exports.sourcererScopeMissingPatterns = exports.sourcererScopeIsLoading = exports.sourcererScope = exports.signalIndexName = exports.signalIndexMappingOutdated = exports.kibanaDataViews = exports.defaultDataView = void 0;
var _reselect = require("reselect");
var _constants = require("../../data_view_manager/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCERER_SCOPE_MAX_SIZE = Object.keys(_constants.PageScope).length;
const selectSourcerer = state => state.sourcerer;
const sourcererScopes = exports.sourcererScopes = (0, _reselect.createSelector)(selectSourcerer, sourcerer => sourcerer.sourcererScopes);
const sourcererScope = exports.sourcererScope = (0, _reselect.createSelector)(sourcererScopes, (state, scopeId) => scopeId, (scopes, scopeId) => scopes[scopeId], {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const sourcererScopeIsLoading = exports.sourcererScopeIsLoading = (0, _reselect.createSelector)(sourcererScope, scope => scope.loading, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const sourcererScopeSelectedDataViewId = exports.sourcererScopeSelectedDataViewId = (0, _reselect.createSelector)(sourcererScope, scope => scope.selectedDataViewId, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const sourcererScopeSelectedPatterns = exports.sourcererScopeSelectedPatterns = (0, _reselect.createSelector)(sourcererScope, scope => scope.selectedPatterns, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const sourcererScopeMissingPatterns = exports.sourcererScopeMissingPatterns = (0, _reselect.createSelector)(sourcererScope, scope => scope.missingPatterns, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const kibanaDataViews = exports.kibanaDataViews = (0, _reselect.createSelector)(selectSourcerer, sourcerer => sourcerer.kibanaDataViews, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const defaultDataView = exports.defaultDataView = (0, _reselect.createSelector)(selectSourcerer, sourcerer => sourcerer.defaultDataView, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const signalIndexName = exports.signalIndexName = (0, _reselect.createSelector)(selectSourcerer, sourcerer => sourcerer.signalIndexName, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});
const signalIndexMappingOutdated = exports.signalIndexMappingOutdated = (0, _reselect.createSelector)(selectSourcerer, sourcerer => sourcerer.signalIndexMappingOutdated, {
  memoizeOptions: {
    maxSize: SOURCERER_SCOPE_MAX_SIZE
  }
});