"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialSourcererState = exports.initSourcererScope = exports.initDataView = void 0;
var _common = require("@kbn/timelines-plugin/common");
var _constants = require("../../data_view_manager/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Data related to each sourcerer scope
 */

/**
 * DataView from Kibana + timelines/index_fields enhanced field data
 */

/**
 * Combined data from SourcererDataView and SourcererScope to create
 * selected data view state
 */

/**
 * sourcerer model for redux
 */

const initSourcererScope = exports.initSourcererScope = {
  loading: false,
  selectedDataViewId: null,
  selectedPatterns: [],
  missingPatterns: []
};
const initDataView = exports.initDataView = {
  browserFields: _common.EMPTY_BROWSER_FIELDS,
  id: '',
  fields: undefined,
  loading: false,
  patternList: [],
  title: '',
  dataView: undefined
};
const initialSourcererState = exports.initialSourcererState = {
  defaultDataView: initDataView,
  alertDataView: initDataView,
  attackDataView: initDataView,
  kibanaDataViews: [],
  signalIndexName: null,
  signalIndexMappingOutdated: null,
  sourcererScopes: {
    [_constants.PageScope.default]: {
      ...initSourcererScope,
      id: _constants.PageScope.default
    },
    [_constants.PageScope.alerts]: {
      ...initSourcererScope,
      id: _constants.PageScope.alerts
    },
    [_constants.PageScope.attacks]: {
      ...initSourcererScope,
      id: _constants.PageScope.attacks
    },
    [_constants.PageScope.timeline]: {
      ...initSourcererScope,
      id: _constants.PageScope.timeline
    },
    [_constants.PageScope.analyzer]: {
      ...initSourcererScope,
      id: _constants.PageScope.analyzer
    },
    [_constants.PageScope.explore]: {
      ...initSourcererScope,
      id: _constants.PageScope.explore
    }
  }
};