"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemReadinessLinks = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../app/translations");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const siemReadinessLinks = exports.siemReadinessLinks = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`]],
  globalNavPosition: 13,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.siem_readiness', {
    defaultMessage: 'SIEM Readiness'
  })],
  experimentalKey: 'siemReadinessDashboard',
  uiSettingRequired: _constants.ENABLE_SIEM_READINESS_SETTING,
  id: _constants.SecurityPageName.siemReadiness,
  path: _constants.SIEM_READINESS_PATH,
  title: _translations.SIEM_READINESS
};