"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OriginalRuleQuery = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _xmlFormatter = _interopRequireDefault(require("xml-formatter"));
var _header = require("./header");
var _query_viewer = require("./query_viewer");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rule_details_flyout/tabs/translation/query_details/original_rule_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OriginalRuleQuery = exports.OriginalRuleQuery = /*#__PURE__*/_react.default.memo(({
  migrationRule
}) => {
  const {
    title,
    tooltip
  } = (0, _react.useMemo)(() => ({
    title: migrationRule.original_rule.vendor === 'splunk' ? i18n.SPLUNK_QUERY_TITLE : i18n.QRADAR_RULE_TITLE,
    tooltip: migrationRule.original_rule.vendor === 'splunk' ? i18n.SPLUNK_QUERY_TOOLTIP : i18n.QRADAR_RULE_TITLE_TOOLTIP
  }), [migrationRule.original_rule.vendor]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.QueryHeader, {
    title: title,
    tooltip: tooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    "data-test-subj": "queryHorizontalRule",
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_query_viewer.QueryViewer, {
    ruleName: migrationRule.original_rule.title,
    query: migrationRule.original_rule.query_language === 'xml' ? (0, _xmlFormatter.default)(migrationRule.original_rule.query) : migrationRule.original_rule.query,
    language: migrationRule.original_rule.query_language,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }));
});
OriginalRuleQuery.displayName = 'OriginalRuleQuery';