"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardsFileUploadStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _dashboards_file_upload = require("./dashboards_file_upload");
var _use_create_migration = require("../../../../../../service/hooks/use_create_migration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/steps/upload_dashboards/sub_steps/dashboards_file_upload/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useDashboardsFileUploadStep = ({
  status,
  migrationStats,
  migrationName,
  onDashboardsFileChanged,
  onFileUpload,
  onMigrationCreated
}) => {
  const [isCreated, setIsCreated] = (0, _react.useState)(!!migrationStats);
  const onSuccess = (0, _react.useCallback)(stats => {
    setIsCreated(true);
    onMigrationCreated(stats);
  }, [onMigrationCreated]);
  const {
    createMigration,
    isLoading,
    error
  } = (0, _use_create_migration.useCreateMigration)(onSuccess);
  const uploadStepStatus = (0, _react.useMemo)(() => {
    if (isLoading) {
      return 'loading';
    }
    if (error) {
      return 'danger';
    }
    return status;
  }, [isLoading, error, status]);
  return {
    title: i18n.DASHBOARDS_DATA_INPUT_FILE_UPLOAD_TITLE,
    status: uploadStepStatus,
    children: /*#__PURE__*/_react.default.createElement(_dashboards_file_upload.DashboardsFileUpload, {
      createMigration: createMigration,
      migrationName: migrationName,
      isLoading: isLoading,
      isCreated: isCreated,
      apiError: error === null || error === void 0 ? void 0 : error.message,
      onDashboardsFileChanged: onDashboardsFileChanged,
      onFileUpload: onFileUpload,
      onMigrationCreated: onMigrationCreated,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    })
  };
};
exports.useDashboardsFileUploadStep = useDashboardsFileUploadStep;