"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requiredSiemMigrationCapabilities = exports.getMissingCapabilitiesChecker = void 0;
var _constants = require("@kbn/security-solution-features/constants");
var _i18n = require("@kbn/i18n");
var _capabilities = require("../../../common/lib/capabilities");
var _constants2 = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const minimumCapabilities = [{
  capability: `${_constants2.SECURITY_FEATURE_ID}.show`,
  description: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.capabilities.securityAll', {
    defaultMessage: 'Security > Security: Read'
  })
}, {
  capability: `${_constants.SIEM_MIGRATIONS_FEATURE_ID}.all`,
  description: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.capabilities.siemMigrationsAll', {
    defaultMessage: 'Security > SIEM migrations: All'
  })
}];
const allCapabilities = [{
  capability: `${_constants2.SECURITY_FEATURE_ID}.crud`,
  description: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.capabilities.securityAll', {
    defaultMessage: 'Security > Security: All'
  })
}, {
  capability: `${_constants.SIEM_MIGRATIONS_FEATURE_ID}.all`,
  description: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.capabilities.siemMigrationsAll', {
    defaultMessage: 'Security > SIEM migrations: All'
  })
}, {
  capability: 'actions.execute',
  description: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.capabilities.connectorsRead', {
    defaultMessage: 'Management > Actions and Connectors: Read'
  })
}];
const requiredSiemMigrationCapabilities = exports.requiredSiemMigrationCapabilities = {
  minimum: minimumCapabilities,
  all: allCapabilities
};
const getMissingCapabilitiesChecker = (requiredCapabilities = requiredSiemMigrationCapabilities) => {
  return (capabilities, level = 'all') => {
    const checker = new _capabilities.CapabilitiesChecker(capabilities);
    return requiredCapabilities[level].filter(required => !checker.has(required.capability));
  };
};
exports.getMissingCapabilitiesChecker = getMissingCapabilitiesChecker;