"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemMigrationsBodyConfig = exports.defaultExternalDetectionsBodyConfig = exports.defaultBodyConfig = void 0;
var _i18n = require("@kbn/i18n");
var _integrations = require("./cards/integrations");
var _dashboards = require("./cards/dashboards");
var _rules = require("./cards/rules");
var _alerts = require("./cards/alerts");
var _assistant = require("./cards/assistant");
var _ai_connector = require("./cards/siem_migrations/ai_connector");
var _integrations2 = require("./cards/siem_migrations/integrations");
var _integrations_external_detections = require("./cards/integrations_external_detections");
var _knowledge_source = require("./cards/knowledge_source");
var _rules2 = require("./cards/siem_migrations/start_migration/rules");
var _dashboards2 = require("./cards/siem_migrations/start_migration/dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultBodyConfig = exports.defaultBodyConfig = [{
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.dataGroup.title', {
    defaultMessage: 'Ingest your data'
  }),
  cards: [_integrations.integrationsCardConfig, _dashboards.dashboardsCardConfig]
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsGroup.title', {
    defaultMessage: 'Configure rules and alerts'
  }),
  cards: [_rules.rulesCardConfig, _alerts.alertsCardConfig]
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.discoverGroup.title', {
    defaultMessage: 'Discover Elastic AI'
  }),
  // TODO: Add attackDiscoveryCardConfig when it is ready (https://github.com/elastic/kibana/issues/189487)
  cards: [_assistant.assistantCardConfig]
}];
const defaultExternalDetectionsBodyConfig = exports.defaultExternalDetectionsBodyConfig = [{
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.externalDetections.dataGroup.title', {
    defaultMessage: 'Ingest your data'
  }),
  cards: [_integrations_external_detections.integrationsExternalDetectionsCardConfig, _knowledge_source.knowledgeSourceCardConfig]
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.externalDetections.customizeLLMGroup.title', {
    defaultMessage: 'Customize your LLM'
  }),
  cards: [_assistant.assistantCardConfig]
}];
const siemMigrationsBodyConfig = exports.siemMigrationsBodyConfig = [{
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.configure.title', {
    defaultMessage: 'Configure'
  }),
  cards: [_ai_connector.aiConnectorCardConfig]
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.migrate.title', {
    defaultMessage: 'Migrate rules & dashboards'
  }),
  cards: [_rules2.startRuleMigrationCardConfig, _integrations2.siemMigrationIntegrationsCardConfig, _dashboards2.startDashboardMigrationCardConfig]
}];