"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchNotes = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _user_privileges = require("../../common/components/user_privileges");
var _notes = require("../store/notes.slice");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns a function to fetch the notes for an array of documents
 */
const useFetchNotes = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    notesPrivileges: {
      read: canReadNotes
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const onLoad = (0, _react.useCallback)(events => {
    if (!canReadNotes || events.length === 0) return;
    const eventIds = events.map(event => event._id).filter(id => id != null);
    dispatch((0, _notes.fetchNotesByDocumentIds)({
      documentIds: eventIds
    }));
  }, [dispatch, canReadNotes]);
  return {
    onLoad
  };
};
exports.useFetchNotes = useFetchNotes;