"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointExceptionsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _public = require("@kbn/lists-plugin/public");
var _use_suggestions = require("../../../../hooks/use_suggestions");
var _constants = require("../../../../../../common/endpoint/constants");
var _source = require("../../../../../common/containers/source");
var _formatted_error = require("../../../../components/formatted_error");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _loader = require("../../../../../common/components/loader");
var _kibana = require("../../../../../common/lib/kibana");
var _utils = require("../../../../common/utils");
var _translations = require("../../translations");
var _translations2 = require("../../../../common/translations");
var _constants2 = require("../../constants");
var _item_comments = require("../../../../../detection_engine/rule_exceptions/components/item_comments");
var _show_value_list_modal = require("../../../../../value_list/components/show_value_list_modal");
var _api_client = require("../../service/api_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_exceptions/view/components/endpoint_exceptions_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ENDPOINT_ALERTS_INDEX_NAMES = [_constants.alertsIndexPattern];
const OS_OPTIONS = [{
  inputDisplay: _translations2.OS_TITLES[_securitysolutionUtils.OperatingSystem.WINDOWS],
  value: [_securitysolutionUtils.OperatingSystem.WINDOWS]
}, {
  inputDisplay: _translations2.OS_TITLES[_securitysolutionUtils.OperatingSystem.MAC],
  value: [_securitysolutionUtils.OperatingSystem.MAC]
}, {
  inputDisplay: _translations2.OS_TITLES[_securitysolutionUtils.OperatingSystem.LINUX],
  value: [_securitysolutionUtils.OperatingSystem.LINUX]
}, {
  inputDisplay: _translations2.OPERATING_SYSTEM_WINDOWS_AND_MAC,
  value: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC]
}];
const defaultConditionEntry = () => [{
  field: '',
  operator: 'included',
  type: 'match',
  value: ''
}];
const cleanupEntries = item => item.entries.forEach(e => {
  delete e.id;
});
const EndpointExceptionsForm = exports.EndpointExceptionsForm = /*#__PURE__*/(0, _react.memo)(({
  allowSelectOs = true,
  item: exception,
  onChange,
  mode,
  error: submitError
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)('endpointExceptions-form');
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const getSuggestionsFn = (0, _react.useCallback)(({
    field,
    query
  }) => {
    const endpointExceptionsAPIClient = new _api_client.EndpointExceptionsApiClient(http);
    return endpointExceptionsAPIClient.getSuggestions({
      field: field.name,
      query
    });
  }, [http]);
  const autocompleteSuggestions = (0, _use_suggestions.useSuggestions)(getSuggestionsFn);
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  const [hasNameError, toggleHasNameError] = (0, _react.useState)(!exception.name);
  const [newComment, setNewComment] = (0, _react.useState)('');
  const [hasCommentError, setHasCommentError] = (0, _react.useState)(false);
  const [hasBeenInputNameVisited, setHasBeenInputNameVisited] = (0, _react.useState)(false);
  const [hasDuplicateFields, setHasDuplicateFields] = (0, _react.useState)(false);
  const [hasWildcardWithWrongOperator, setHasWildcardWithWrongOperator] = (0, _react.useState)((0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)([exception]));
  const [hasPartialCodeSignatureWarning, setHasPartialCodeSignatureWarning] = (0, _react.useState)((0, _securitysolutionListUtils.hasPartialCodeSignatureEntry)([exception]));
  const [isIndexPatternLoading, {
    indexPatterns
  }] = (0, _source.useFetchIndex)(ENDPOINT_ALERTS_INDEX_NAMES, undefined, _constants.ENDPOINT_FIELDS_SEARCH_STRATEGY);
  const [areConditionsValid, setAreConditionsValid] = (0, _react.useState)(!!exception.entries.length);
  // compute this for initial render only
  const existingComments = (0, _react.useMemo)(() => exception === null || exception === void 0 ? void 0 : exception.comments,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const isFormValid = (0, _react.useMemo)(() => {
    // verify that it has legit entries
    // and not just default entry without values
    return !hasNameError && !hasCommentError && !!exception.entries.length && exception.entries.some(e => e.value !== '' || e.value.length);
  }, [hasCommentError, hasNameError, exception.entries]);
  const processChanged = (0, _react.useCallback)(updatedItem => {
    const item = updatedItem ? {
      ...exception,
      ...updatedItem
    } : exception;
    cleanupEntries(item);
    onChange({
      item,
      isValid: isFormValid && areConditionsValid && hasFormChanged,
      confirmModalLabels: hasWildcardWithWrongOperator ? (0, _translations2.CONFIRM_WARNING_MODAL_LABELS)(_i18n.i18n.translate('xpack.securitySolution.endpointException.flyoutForm.confirmModal.name', {
        defaultMessage: 'endpoint exception'
      })) : undefined
    });
  }, [areConditionsValid, exception, hasFormChanged, isFormValid, onChange, hasWildcardWithWrongOperator]);
  const endpointExceptionItem = (0, _react.useMemo)(() => {
    const ef = exception;
    ef.entries = exception.entries.length ? exception.entries : defaultConditionEntry();
    cleanupEntries(ef);
    setAreConditionsValid(!!exception.entries.length);
    return ef;
  }, [exception]);
  const handleOnChangeName = (0, _react.useCallback)(event => {
    if (!exception) return;
    const name = event.target.value.trim();
    toggleHasNameError(!name);
    processChanged({
      name
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const nameInputMemo = (0, _react.useMemo)(() => {
    var _exception$name;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _translations.NAME_LABEL,
      fullWidth: true,
      isInvalid: hasNameError && hasBeenInputNameVisited,
      error: _translations.NAME_ERROR,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: hasNameError && hasBeenInputNameVisited,
      "aria-label": _translations.NAME_LABEL,
      id: "endpointExceptionFormInputName",
      defaultValue: (_exception$name = exception === null || exception === void 0 ? void 0 : exception.name) !== null && _exception$name !== void 0 ? _exception$name : '',
      "data-test-subj": getTestId('name-input'),
      fullWidth: true,
      maxLength: 256,
      required: hasBeenInputNameVisited,
      onChange: handleOnChangeName,
      onBlur: () => !hasBeenInputNameVisited && setHasBeenInputNameVisited(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }));
  }, [getTestId, hasNameError, handleOnChangeName, hasBeenInputNameVisited, exception === null || exception === void 0 ? void 0 : exception.name]);
  const handleOnDescriptionChange = (0, _react.useCallback)(event => {
    if (!exception) return;
    if (!hasFormChanged) setHasFormChanged(true);
    processChanged({
      description: event.target.value.toString().trim()
    });
  }, [exception, hasFormChanged, processChanged]);
  const descriptionInputMemo = (0, _react.useMemo)(() => {
    var _exception$descriptio;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _translations.DESCRIPTION_LABEL,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      id: "endpointExceptionFormInputDescription",
      defaultValue: (_exception$descriptio = exception === null || exception === void 0 ? void 0 : exception.description) !== null && _exception$descriptio !== void 0 ? _exception$descriptio : '',
      onChange: handleOnDescriptionChange,
      fullWidth: true,
      "data-test-subj": getTestId('description-input'),
      "aria-label": _translations.DESCRIPTION_LABEL,
      maxLength: 256,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 9
      }
    }));
  }, [exception === null || exception === void 0 ? void 0 : exception.description, getTestId, handleOnDescriptionChange]);
  const handleOnOsChange = (0, _react.useCallback)(os => {
    if (!exception) return;
    processChanged({
      os_types: os,
      entries: exception.entries
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const osInputMemo = (0, _react.useMemo)(() => {
    var _OS_OPTIONS$find;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _translations.OS_LABEL,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      name: "os",
      options: OS_OPTIONS,
      fullWidth: true,
      "data-test-subj": getTestId('osSelectField'),
      valueOfSelected: (_OS_OPTIONS$find = OS_OPTIONS.find(option => JSON.stringify(option.value) === JSON.stringify(exception === null || exception === void 0 ? void 0 : exception.os_types))) === null || _OS_OPTIONS$find === void 0 ? void 0 : _OS_OPTIONS$find.value,
      onChange: handleOnOsChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 9
      }
    }));
  }, [getTestId, handleOnOsChange, exception === null || exception === void 0 ? void 0 : exception.os_types]);
  const handleOnChangeComment = (0, _react.useCallback)(value => {
    if (!exception) return;
    setNewComment(value);
    processChanged({
      comments: [{
        comment: value
      }]
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const commentsInputMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_item_comments.ExceptionItemComments, {
    exceptionItemComments: existingComments,
    newCommentValue: newComment,
    newCommentOnChange: handleOnChangeComment,
    setCommentError: setHasCommentError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }), [existingComments, handleOnChangeComment, newComment]);
  const commentsSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.commentsSectionTitle",
    defaultMessage: "Comments",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.commentsSectionDescription",
    defaultMessage: "Add a comment to your endpoint exception.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 9
    }
  }), commentsInputMemo), [commentsInputMemo]);
  const detailsSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.detailsSectionTitle",
    defaultMessage: "Details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  }, _translations.ABOUT_ENDPOINT_EXCEPTIONS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 9
    }
  }), nameInputMemo, descriptionInputMemo), [nameInputMemo, descriptionInputMemo]);
  const handleOnBuilderChange = (0, _react.useCallback)(arg => {
    var _arg$exceptionItems$, _exception$name2, _exception$descriptio2, _exception$comments, _exception$os_types, _exception$tags, _arg$exceptionItems$3, _arg$exceptionItems$4;
    const isCalledWithoutChanges = !hasFormChanged && arg.exceptionItems[0] === undefined || (0, _lodash.isEqual)((_arg$exceptionItems$ = arg.exceptionItems[0]) === null || _arg$exceptionItems$ === void 0 ? void 0 : _arg$exceptionItems$.entries, exception === null || exception === void 0 ? void 0 : exception.entries);
    if (isCalledWithoutChanges) {
      var _arg$exceptionItems$2;
      const addedFields = ((_arg$exceptionItems$2 = arg.exceptionItems[0]) === null || _arg$exceptionItems$2 === void 0 ? void 0 : _arg$exceptionItems$2.entries.map(e => e.field)) || [''];
      setHasDuplicateFields((0, _utils.computeHasDuplicateFields)((0, _utils.getAddedFieldsCounts)(addedFields)));
      return;
    } else {
      setHasDuplicateFields(false);
    }

    // handle wildcard with wrong operator case
    setHasWildcardWithWrongOperator((0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)(arg.exceptionItems));
    setHasPartialCodeSignatureWarning((0, _securitysolutionListUtils.hasPartialCodeSignatureEntry)(arg.exceptionItems));
    const updatedItem = arg.exceptionItems[0] !== undefined ? {
      ...arg.exceptionItems[0],
      name: (_exception$name2 = exception === null || exception === void 0 ? void 0 : exception.name) !== null && _exception$name2 !== void 0 ? _exception$name2 : '',
      description: (_exception$descriptio2 = exception === null || exception === void 0 ? void 0 : exception.description) !== null && _exception$descriptio2 !== void 0 ? _exception$descriptio2 : '',
      comments: (_exception$comments = exception === null || exception === void 0 ? void 0 : exception.comments) !== null && _exception$comments !== void 0 ? _exception$comments : [],
      os_types: (_exception$os_types = exception === null || exception === void 0 ? void 0 : exception.os_types) !== null && _exception$os_types !== void 0 ? _exception$os_types : [_securitysolutionUtils.OperatingSystem.WINDOWS],
      tags: (_exception$tags = exception === null || exception === void 0 ? void 0 : exception.tags) !== null && _exception$tags !== void 0 ? _exception$tags : [],
      meta: exception.meta
    } : {
      ...exception,
      entries: [{
        field: '',
        operator: 'included',
        type: 'match',
        value: ''
      }]
    };
    const hasValidConditions = arg.exceptionItems[0] !== undefined ? !(arg.errorExists && !((_arg$exceptionItems$3 = arg.exceptionItems[0]) !== null && _arg$exceptionItems$3 !== void 0 && (_arg$exceptionItems$4 = _arg$exceptionItems$3.entries) !== null && _arg$exceptionItems$4 !== void 0 && _arg$exceptionItems$4.length)) : false;
    setAreConditionsValid(hasValidConditions);
    processChanged(updatedItem);
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const exceptionBuilderComponentMemo = (0, _react.useMemo)(() => (0, _public.getExceptionBuilderComponentLazy)({
    allowLargeValueLists: false,
    httpService: http,
    autocompleteService: autocompleteSuggestions,
    exceptionListItems: [endpointExceptionItem],
    listType: _constants2.ENDPOINT_EXCEPTIONS_LIST_DEFINITION.type,
    listId: _constants2.ENDPOINT_EXCEPTIONS_LIST_DEFINITION.list_id,
    listNamespaceType: 'agnostic',
    indexPatterns,
    isOrDisabled: false,
    isAndDisabled: false,
    isNestedDisabled: false,
    dataTestSubj: 'endpoint-exception-builder',
    idAria: 'endpoint-exception-builder',
    onChange: handleOnBuilderChange,
    osTypes: exception.os_types,
    showValueListModal: _show_value_list_modal.ShowValueListModal
  }), [http, autocompleteSuggestions, endpointExceptionItem, indexPatterns, handleOnBuilderChange, exception.os_types]);
  const criteriaSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.criteriaSectionTitle",
    defaultMessage: "Conditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 11
    }
  }, allowSelectOs ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.criteriaSectionDescription.withOs",
    defaultMessage: "Select an operating system and add conditions.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.criteriaSectionDescription.withoutOs",
    defaultMessage: "Add conditions.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 476,
      columnNumber: 9
    }
  }), allowSelectOs ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, osInputMemo, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 13
    }
  })) : null, exceptionBuilderComponentMemo), [allowSelectOs, exceptionBuilderComponentMemo, osInputMemo]);
  (0, _react.useEffect)(() => {
    processChanged();
  }, [processChanged]);
  if (isIndexPatternLoading || !exception) {
    return /*#__PURE__*/_react.default.createElement(_loader.Loader, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 494,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    error: submitError ? /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: submitError,
      "data-test-subj": getTestId('submitError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 502,
        columnNumber: 11
      }
    }) : undefined,
    isInvalid: !!submitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 5
    }
  }, detailsSection, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 7
    }
  }), criteriaSection, hasWildcardWithWrongOperator && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.WildCardWithWrongOperatorCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 510,
      columnNumber: 40
    }
  }), hasWildcardWithWrongOperator && hasPartialCodeSignatureWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 511,
      columnNumber: 74
    }
  }), hasPartialCodeSignatureWarning && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.PartialCodeSignatureCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 512,
      columnNumber: 42
    }
  }), hasDuplicateFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 515,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "duplicate-fields-warning-message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointException.warningMessage.duplicateFields",
    defaultMessage: "Using multiples of the same field values can degrade Endpoint performance and/or create ineffective rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 7
    }
  }), commentsSection);
});
EndpointExceptionsForm.displayName = 'EndpointExceptionsForm';