"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapWithNotice = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/lib/get_not_supported_arg_about_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Wraps some content (ex. Command argument's about info) with a notice that is prefixed with an icon.
 * Primary reason to use this function is to be abel to return JSX to be used in the
 * `console_commands_definition` file which is a `.ts` file
 * @param content
 * @param noticeMessage
 */
const wrapWithNotice = (content, noticeMessage) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    size: "s",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }), " ", noticeMessage));
};
exports.wrapWithNotice = wrapWithNotice;