"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryDumpActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _memory_dump_response_action_output_result = require("../../memory_dump_response_action_output_result");
var _use_send_memory_dump_request = require("../../../hooks/response_actions/use_send_memory_dump_request");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/memory_dump_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MemoryDumpActionResult = exports.MemoryDumpActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin, _command$commandDefin2;
  const actionCreator = (0, _use_send_memory_dump_request.useSendMemoryDumpRequest)();
  const {
    agentType,
    endpointId
  } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
  const actionRequestBody = (0, _react.useMemo)(() => {
    const {
      comment,
      kernel,
      pid,
      entityId
    } = command.args.args;
    if (!endpointId) {
      return;
    }
    const reqBody = {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      ...(comment !== null && comment !== void 0 && comment[0] ? {
        comment: comment === null || comment === void 0 ? void 0 : comment[0]
      } : {}),
      parameters: {
        type: kernel !== null && kernel !== void 0 && kernel[0] ? 'kernel' : 'process',
        ...(pid ? {
          pid: pid[0]
        } : {}),
        ...(entityId ? {
          entity_id: entityId[0]
        } : {})
      }
    };
    return reqBody;
  }, [agentType, command.args.args, endpointId]);
  const {
    result,
    actionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'memoryDump'
  });
  if (actionDetails !== null && actionDetails !== void 0 && actionDetails.isCompleted && actionDetails.wasSuccessful) {
    return /*#__PURE__*/_react.default.createElement(ResultComponent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_memory_dump_response_action_output_result.MemoryDumpResponseActionOutputResult, {
      action: actionDetails,
      agentId: endpointId,
      "data-test-subj": "memoryDumpResult",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }));
  }
  return result;
});
MemoryDumpActionResult.displayName = 'MemoryDumpActionResult';