"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecuteCommandArgAboutInfo = exports.ExecuteActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_execute_endpoint_request = require("../../../hooks/response_actions/use_send_execute_endpoint_request");
var _utils = require("../lib/utils");
var _endpoint_execute_action = require("../../endpoint_execute_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/execute_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExecuteActionResult = exports.ExecuteActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3, _command$args$args2, _command$commandDefin4, _command$commandDefin5;
  const actionCreator = (0, _use_send_execute_endpoint_request.useSendExecuteEndpoint)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2, _command$args$args$ti, _command$args$args, _command$args$args$co;
    const {
      endpointId,
      agentType
    } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
    if (!endpointId) {
      return;
    }
    return {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      parameters: {
        command: command.args.args.command[0],
        timeout: (0, _utils.parsedExecuteTimeout)((_command$args$args$ti = command.args.args.timeout) === null || _command$args$args$ti === void 0 ? void 0 : _command$args$args$ti[0])
      },
      comment: (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0]
    };
  }, [(_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : _command$commandDefin3.meta, command.args.args.command, command.args.args.timeout, (_command$args$args2 = command.args.args) === null || _command$args$args2 === void 0 ? void 0 : _command$args$args2.comment]);
  const {
    result,
    actionDetails: completedActionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'execute'
  });
  if (!completedActionDetails || !completedActionDetails.wasSuccessful) {
    return result;
  }

  // Show results
  return /*#__PURE__*/_react.default.createElement(ResultComponent, {
    "data-test-subj": "executeSuccess",
    showAs: "success",
    title: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.executeAction.successTitle', {
      defaultMessage: 'Command execution was successful.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
    action: completedActionDetails,
    canAccessFileDownloadLink: true,
    agentId: (_command$commandDefin4 = command.commandDefinition) === null || _command$commandDefin4 === void 0 ? void 0 : (_command$commandDefin5 = _command$commandDefin4.meta) === null || _command$commandDefin5 === void 0 ? void 0 : _command$commandDefin5.endpointId,
    textSize: "s",
    "data-test-subj": "console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
});
ExecuteActionResult.displayName = 'ExecuteActionResult';
const ABOUT_ESCAPE_DASHES = _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.execute.args.command.aboutConsecutiveDashes', {
  defaultMessage: 'Multiple consecutive dashes in the value provided must be escaped. Ex:'
});
const ABOUT_ESCAPE_QUOTES = _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.execute.args.command.aboutQuotes', {
  defaultMessage: 'Quotes provided in the value can be used without escaping. Ex:'
});
const getExecuteCommandArgAboutInfo = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointConsoleCommands.execute.args.command.about",
    defaultMessage: "The command to execute.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }), `${ABOUT_ESCAPE_DASHES} execute --command "/opt/directory\\-\\-\\-directory/myBinary \\-\\-version"`, /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), `${ABOUT_ESCAPE_QUOTES} execute --command "cd "C:\\Program Files\\directory""`);
};
exports.getExecuteCommandArgAboutInfo = getExecuteCommandArgAboutInfo;