"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInputCommand = void 0;
var _react = require("react");
var _entered_input = require("../../components/command_input/lib/entered_input");
var _console_state = require("../../components/console_state/console_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a `Command` interface that represents the command that the user has entered
 * into the console (if any)
 */
const useInputCommand = () => {
  const {
    leftOfCursorText,
    rightOfCursorText,
    parsedInput,
    enteredCommand
  } = (0, _console_state.useConsoleStore)().state.input;
  return (0, _react.useMemo)(() => {
    if (enteredCommand) {
      const inputDisplay = new _entered_input.EnteredInput(leftOfCursorText, rightOfCursorText, parsedInput, enteredCommand).getFullText(true);
      return {
        inputDisplay,
        input: parsedInput.input,
        args: parsedInput,
        argState: enteredCommand.argState,
        commandDefinition: enteredCommand.commandDefinition
      };
    }
  }, [enteredCommand, leftOfCursorText, parsedInput, rightOfCursorText]);
};
exports.useInputCommand = useInputCommand;