"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToUserDetails = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _react = require("react");
var _search_strategy = require("../../../../../common/search_strategy");
var _kibana = require("../../../../common/lib/kibana");
var _telemetry = require("../../../../common/lib/telemetry");
var _user_details_left = require("../../user_details_left");
var _constants = require("../../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToUserDetails = ({
  userName,
  email,
  scopeId,
  contextID,
  isRiskScoreExist,
  hasMisconfigurationFindings,
  hasNonClosedAlerts,
  isPreviewMode
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  return (0, _react.useCallback)(path => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.RiskInputsExpandedFlyoutOpened, {
      entity: _search_strategy.EntityType.user
    });
    const left = {
      id: _user_details_left.UserDetailsPanelKey,
      params: {
        isRiskScoreExist,
        scopeId,
        user: {
          name: userName,
          email
        },
        path,
        hasMisconfigurationFindings,
        hasNonClosedAlerts
      }
    };
    const right = {
      id: _constants.UserPanelKey,
      params: {
        contextID,
        userName,
        scopeId
      }
    };
    if (isPreviewMode) {
      openFlyout({
        right,
        left
      });
    } else {
      openLeftPanel(left);
    }
  }, [telemetry, openLeftPanel, isRiskScoreExist, scopeId, userName, email, hasMisconfigurationFindings, hasNonClosedAlerts, isPreviewMode, openFlyout, contextID]);
};
exports.useNavigateToUserDetails = useNavigateToUserDetails;