"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MESSAGE_TEXT_TEST_ID = void 0;
exports.MessageText = MessageText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _custom_code_block = require("@kbn/elastic-assistant/impl/get_comments/custom_codeblock/custom_code_block");
var _custom_codeblock_markdown_plugin = require("@kbn/elastic-assistant/impl/get_comments/custom_codeblock/custom_codeblock_markdown_plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/message_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MESSAGE_TEXT_TEST_ID = exports.MESSAGE_TEXT_TEST_ID = 'ease-alert-flyout-message-text';
const getPluginDependencies = () => {
  const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
  const processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
  const {
    components
  } = processingPlugins[1][1];
  processingPlugins[1][1].components = {
    ...components,
    contentReference: () => null,
    customCodeBlock: props => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_custom_code_block.CustomCodeBlock, {
      value: props.value,
      lang: props.lang,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    })),
    table: props => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTable, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    })),
    th: props => {
      const {
        children,
        ...rest
      } = props;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, (0, _extends2.default)({}, rest, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 14
        }
      }), children);
    },
    tr: props => /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRow, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 20
      }
    })),
    td: props => {
      const {
        children,
        ...rest
      } = props;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, (0, _extends2.default)({
        truncateText: true
      }, rest, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      }), children);
    }
  };
  return {
    parsingPluginList: [_custom_codeblock_markdown_plugin.customCodeBlockLanguagePlugin, ...parsingPlugins],
    processingPluginList: processingPlugins
  };
};
/**
 * To be used for alert summary. For AI Assistant, use `x-pack/solutions/security/plugins/security_solution/public/assistant/get_comments/stream/message_text.tsx`
 * This component does not handle rendering of any content references, does not supply a loading cursor, and does not augmentMessageCodeBlocks
 */
function MessageText({
  content,
  'data-test-subj': dataTestSubj
}) {
  const containerCss = (0, _react.css)`
    overflow-wrap: anywhere;
  `;
  const {
    parsingPluginList,
    processingPluginList
  } = (0, _react2.useMemo)(() => getPluginDependencies(), []);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: containerCss,
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiMarkdownFormat, {
    "data-test-subj": MESSAGE_TEXT_TEST_ID,
    parsingPluginList: parsingPluginList,
    processingPluginList: processingPluginList,
    textSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, content));
}