"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertPrevalenceFromProcessTree = useAlertPrevalenceFromProcessTree;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_alert_document_analyzer_schema = require("./use_alert_document_analyzer_schema");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../../sourcerer/store");
var _use_security_default_patterns = require("../../../../data_view_manager/hooks/use_security_default_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches the alert prevalence from the process tree
 */
function useAlertPrevalenceFromProcessTree({
  documentId,
  isActiveTimeline,
  indices
}) {
  var _useSelector$patternL, _useSelector;
  const http = (0, _kibana.useHttp)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const oldSecurityDefaultPatterns = (_useSelector$patternL = (_useSelector = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView)) === null || _useSelector === void 0 ? void 0 : _useSelector.patternList) !== null && _useSelector$patternL !== void 0 ? _useSelector$patternL : [];
  const {
    indexPatterns: experimentalSecurityDefaultIndexPatterns
  } = (0, _use_security_default_patterns.useSecurityDefaultPatterns)();
  const securityDefaultPatterns = newDataViewPickerEnabled ? experimentalSecurityDefaultIndexPatterns : oldSecurityDefaultPatterns;
  const alertAndOriginalIndices = (0, _react.useMemo)(() => [...new Set(securityDefaultPatterns.concat(indices))], [indices, securityDefaultPatterns]);
  const {
    loading,
    id,
    schema,
    agentId
  } = (0, _use_alert_document_analyzer_schema.useAlertDocumentAnalyzerSchema)({
    documentId,
    indices: alertAndOriginalIndices
  });
  const query = (0, _reactQuery.useQuery)(['getAlertPrevalenceFromProcessTree', id], () => {
    return http.post(`/api/endpoint/resolver/tree`, {
      body: JSON.stringify({
        schema,
        ancestors: 200,
        descendants: 500,
        indexPatterns: alertAndOriginalIndices,
        nodes: [id],
        includeHits: true,
        agentId
      })
    });
  }, {
    enabled: schema !== null && id !== null
  });
  if (query.isLoading || loading) {
    return {
      loading: true,
      error: false,
      alertIds: undefined,
      statsNodes: undefined
    };
  } else if (query.data) {
    return {
      loading: false,
      error: false,
      alertIds: query.data.alertIds,
      statsNodes: query.data.statsNodes
    };
  } else {
    return {
      loading: false,
      error: true,
      alertIds: undefined,
      statsNodes: undefined
    };
  }
}