"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsByAncestry = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _correlations_details_alerts_table = require("./correlations_details_alerts_table");
var _use_fetch_related_alerts_by_ancestry = require("../../shared/hooks/use_fetch_related_alerts_by_ancestry");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/related_alerts_by_ancestry.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Show related alerts by ancestry in an expandable panel with a table
 */
const RelatedAlertsByAncestry = ({
  documentId,
  indices,
  scopeId
}) => {
  const {
    loading,
    error,
    data,
    dataCount
  } = (0, _use_fetch_related_alerts_by_ancestry.useFetchRelatedAlertsByAncestry)({
    documentId,
    indices,
    scopeId
  });
  if (error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_correlations_details_alerts_table.CorrelationsDetailsAlertsTable, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.ancestryAlertsTitle",
      defaultMessage: "{count} {count, plural, one {alert} other {alerts}} related by ancestry",
      values: {
        count: dataCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    loading: loading,
    alertIds: data,
    scopeId: scopeId,
    eventId: documentId,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.ancestryAlertsNoDataDescription",
      defaultMessage: "No alerts related by ancestry.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }),
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_ANCESTRY_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.RelatedAlertsByAncestry = RelatedAlertsByAncestry;
RelatedAlertsByAncestry.displayName = 'RelatedAlertsByAncestry';