"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDetailsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _flyout_navigation = require("../shared/components/flyout_navigation");
var _flyout_header = require("../shared/components/flyout_header");
var _footer = require("./footer");
var _header_title = require("./components/header_title");
var _content = require("./content");
var _local_storage = require("./constants/local_storage");
var _panel_keys = require("./constants/panel_keys");
var _kibana = require("../../common/lib/kibana");
var _use_tabs = require("./hooks/use_tabs");
var _context = require("./context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/attack_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Panel to be displayed in Attack Details flyout
 */
const AttackDetailsPanel = exports.AttackDetailsPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    attackId
  } = (0, _context.useAttackDetailsContext)();
  const {
    tabsDisplayed,
    selectedTabId
  } = (0, _use_tabs.useTabs)({
    path
  });
  const setSelectedTabId = tabId => {
    openRightPanel({
      id: _panel_keys.AttackDetailsRightPanelKey,
      path: {
        tab: tabId
      },
      params: {
        attackId
      }
    });
    // saving which tab is currently selected in the right panel in local storage
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.RIGHT_PANEL_SELECTED_TABS, tabId);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_footer.PanelFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
});
AttackDetailsPanel.displayName = 'AttackDetailsPanel';