"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkUsers = exports.ID = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../../../../common/containers/helpers");
var _helpers2 = require("../../../components/paginated_table/helpers");
var _store = require("../../store");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'networkUsersQuery';
const useNetworkUsers = ({
  endDate,
  filterQuery,
  flowTarget,
  id,
  ip,
  skip,
  startDate
}) => {
  const getNetworkUsersSelector = (0, _react.useMemo)(() => _store.networkSelectors.usersSelector(), []);
  const {
    activePage,
    sort,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(getNetworkUsersSelector);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultIndex = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  const [networkUsersRequest, setNetworkUsersRequest] = (0, _react.useState)(null);
  const wrappedLoadMore = (0, _react.useCallback)(newActivePage => {
    setNetworkUsersRequest(prevRequest => {
      if (!prevRequest) {
        return prevRequest;
      }
      return {
        ...prevRequest,
        pagination: (0, _helpers2.generateTablePaginationOptions)(newActivePage, limit)
      };
    });
  }, [limit]);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _network.NetworkQueries.users,
    initialResult: {
      edges: [],
      totalCount: -1,
      pageInfo: {
        activePage: 0,
        fakeTotalCount: 0,
        showMorePagesIndicator: false
      }
    },
    errorMessage: i18n.FAIL_NETWORK_USERS,
    abort: skip
  });
  const networkUsersResponse = (0, _react.useMemo)(() => ({
    endDate,
    networkUsers: response.edges,
    id,
    inspect,
    isInspected: false,
    loadPage: wrappedLoadMore,
    pageInfo: response.pageInfo,
    refetch,
    startDate,
    totalCount: response.totalCount
  }), [endDate, id, inspect, refetch, response.edges, response.pageInfo, response.totalCount, startDate, wrappedLoadMore]);
  (0, _react.useEffect)(() => {
    setNetworkUsersRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        ip,
        defaultIndex,
        factoryQueryType: _network.NetworkQueries.users,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        flowTarget,
        pagination: (0, _helpers2.generateTablePaginationOptions)(activePage, limit),
        sort,
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        }
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [activePage, defaultIndex, endDate, filterQuery, limit, startDate, sort, ip, flowTarget]);
  (0, _react.useEffect)(() => {
    if (!skip && networkUsersRequest) {
      search(networkUsersRequest);
    }
  }, [networkUsersRequest, search, skip]);
  return [loading, networkUsersResponse];
};
exports.useNetworkUsers = useNetworkUsers;