"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkTopNFlow = exports.ID = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _helpers = require("../../../../common/containers/helpers");
var _helpers2 = require("../../../components/paginated_table/helpers");
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'networkTopNFlowQuery';
const useNetworkTopNFlow = ({
  endDate,
  filterQuery,
  flowTarget,
  id,
  indexNames,
  ip,
  skip,
  startDate,
  type
}) => {
  const getTopNFlowSelector = (0, _react.useMemo)(() => _store.networkSelectors.topNFlowSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getTopNFlowSelector(state, type, flowTarget));
  const [networkTopNFlowRequest, setTopNFlowRequest] = (0, _react.useState)(null);
  const loadPage = (0, _react.useCallback)(newActivePage => {
    setTopNFlowRequest(prevRequest => {
      if (!prevRequest) {
        return prevRequest;
      }
      return {
        ...prevRequest,
        pagination: (0, _helpers2.getLimitedPaginationOptions)(newActivePage, limit)
      };
    });
  }, [limit]);
  const {
    loading: isLoadingData,
    result: response,
    search,
    refetch: refetchData,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.NetworkQueries.topNFlow,
    initialResult: {
      edges: []
    },
    errorMessage: i18n.FAIL_NETWORK_TOP_N_FLOW,
    abort: skip
  });
  const {
    loading: isLoadingTotalCount,
    result: responseTotalCount,
    search: searchTotalCount,
    refetch: refetchTotalCount,
    inspect: inspectTotalCount
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.NetworkQueries.topNFlowCount,
    initialResult: {
      totalCount: -1
    },
    errorMessage: i18n.FAIL_NETWORK_TOP_N_FLOW,
    abort: skip
  });
  const isLoading = isLoadingData || isLoadingTotalCount;
  const refetch = (0, _react.useCallback)(() => {
    refetchData();
    refetchTotalCount();
  }, [refetchData, refetchTotalCount]);
  const networkTopNFlowResponse = (0, _react.useMemo)(() => ({
    networkTopNFlow: response.edges,
    id,
    inspect: {
      dsl: [...inspect.dsl, ...inspectTotalCount.dsl],
      response: [...inspect.response, ...inspectTotalCount.response]
    },
    isInspected: false,
    loadPage,
    refetch,
    startDate,
    totalCount: responseTotalCount.totalCount
  }), [id, inspect, inspectTotalCount, refetch, response.edges, responseTotalCount.totalCount, startDate, loadPage]);
  (0, _react.useEffect)(() => {
    setTopNFlowRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex: indexNames,
        factoryQueryType: _search_strategy.NetworkQueries.topNFlow,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        flowTarget,
        ip,
        pagination: (0, _helpers2.getLimitedPaginationOptions)(activePage, limit),
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        sort
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [activePage, endDate, filterQuery, indexNames, ip, limit, startDate, sort, flowTarget]);
  (0, _react.useEffect)(() => {
    if (!skip && networkTopNFlowRequest) {
      search(networkTopNFlowRequest);
      searchTotalCount(networkTopNFlowRequest);
    }
  }, [networkTopNFlowRequest, search, searchTotalCount, skip]);
  return [isLoading, networkTopNFlowResponse];
};
exports.useNetworkTopNFlow = useNetworkTopNFlow;