"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskEngineSettingsQuery = exports.useInvalidateRiskEngineSettingsQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _api = require("../../../api/api");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RISK_ENGINE_SETTINGS = ['GET', 'FETCH_RISK_ENGINE_SETTINGS'];
const useInvalidateRiskEngineSettingsQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(async () => {
    await queryClient.invalidateQueries(FETCH_RISK_ENGINE_SETTINGS, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateRiskEngineSettingsQuery = useInvalidateRiskEngineSettingsQuery;
const useRiskEngineSettingsQuery = () => {
  const {
    fetchRiskEngineSettings
  } = (0, _api.useEntityAnalyticsRoutes)();
  const {
    data: savedRiskEngineSettings,
    isLoading: isLoadingRiskEngineSettings,
    isError
  } = (0, _reactQuery.useQuery)(FETCH_RISK_ENGINE_SETTINGS, async () => {
    const riskEngineSettings = await fetchRiskEngineSettings();
    return (0, _common.getRiskScoreConfigurationWithDefaults)(riskEngineSettings);
  }, {
    retry: false,
    refetchOnWindowFocus: false
  });
  return {
    savedRiskEngineSettings,
    isLoadingRiskEngineSettings,
    isError
  };
};
exports.useRiskEngineSettingsQuery = useRiskEngineSettingsQuery;