"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionViewAllAnomaliesButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _kibana = require("../../../../../common/lib/kibana");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/pad_view_all_anomalies_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const usePadMlAnomalyExplorerUrl = () => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    services
  } = (0, _kibana.useKibana)();
  return (0, _public.useMlHref)(services.ml, services.http.basePath.get(), {
    page: _public.ML_PAGES.ANOMALY_EXPLORER,
    pageState: {
      jobIds: ['pad'],
      timeRange: {
        from,
        to
      },
      mlExplorerSwimlane: {
        viewByFieldName: 'user.name'
      }
    }
  }, [from, to]);
};
const PrivilegedAccessDetectionViewAllAnomaliesButton = () => {
  const anomalyExplorerUrl = usePadMlAnomalyExplorerUrl();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: 'primary',
    fill: false,
    iconType: 'anomalySwimLane',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: anomalyExplorerUrl,
    external: false,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.anomalyExplorer",
    defaultMessage: "View all in Anomaly Explorer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })));
};
exports.PrivilegedAccessDetectionViewAllAnomaliesButton = PrivilegedAccessDetectionViewAllAnomaliesButton;