"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionHeatmap = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _pad_heatmap_interval_hooks = require("./hooks/pad_heatmap_interval_hooks");
var _pad_chart_styling = require("./pad_chart_styling");
var _use_global_time = require("../../../../../../common/containers/use_global_time");
var _illustration_product_no_results_magnifying_glass = _interopRequireDefault(require("../../../../../../common/images/illustration_product_no_results_magnifying_glass.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/pad_chart/pad_heatmap.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const heatmapComponentStyle = {
  brushTool: {
    visible: false
  },
  cell: {
    maxWidth: 'fill',
    label: {
      visible: false
    },
    border: {
      stroke: 'transparent',
      strokeWidth: 0
    }
  },
  xAxisLabel: {
    fontSize: 12,
    padding: {
      top: 10,
      bottom: 10
    }
  },
  yAxisLabel: {
    visible: false,
    // We do not show the yAxisLabel, as we instead render the user names separately in order to link to the User flyout
    fontSize: 14,
    width: 'auto',
    padding: {
      left: 10,
      right: 10
    }
  }
};
const PrivilegedAccessDetectionHeatmapNoResults = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      maxWidth: '600px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.noResultsTitle",
    defaultMessage: "No privileged access detection results match your search criteria",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.noResultsDescription",
    defaultMessage: `Now that you've got the privileged access detection anomaly jobs installed, you can click "ML job settings" above to configure and run them within your environment.`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "200px",
    alt: _i18n.i18n.translate('xpack.securitySolution.privilegedUserMonitoring.privilegedAccessDetection.emptyState.illustrationAlt', {
      defaultMessage: 'No results'
    }),
    url: _illustration_product_no_results_magnifying_glass.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })));
};
const useGlobalTimeInMillis = () => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  return {
    from: new Date(from).getTime(),
    to: new Date(to).getTime()
  };
};
const useXDomainFromGlobalTime = () => {
  const {
    from,
    to
  } = useGlobalTimeInMillis();
  return {
    min: from,
    max: to
  };
};
const useTimeFormatter = () => {
  const {
    from,
    to
  } = useGlobalTimeInMillis();
  return value => (0, _charts.niceTimeFormatter)([from, to])(value, {
    timeZone: 'UTC'
  });
};
const PrivilegedAccessDetectionHeatmap = ({
  records,
  anomalyBands,
  userNames,
  isLoading,
  isError
}) => {
  const intervalForHeatmap = (0, _pad_heatmap_interval_hooks.useIntervalForHeatmap)();
  const timeFormatter = useTimeFormatter();
  const xDomain = useXDomainFromGlobalTime();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      marginTop: `${_pad_chart_styling.padChartStyling.heightOfTopLegend}px`,
      height: `${_pad_chart_styling.padChartStyling.heightOfHeatmap(userNames)}px`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'center',
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  })), isError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.anomalyDetectionDataError', {
      defaultMessage: 'There was an error retrieving privileged access detection anomaly data.'
    }),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }), !isLoading && !isError && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: {
      heatmap: heatmapComponentStyle
    },
    noResults: /*#__PURE__*/_react.default.createElement(PrivilegedAccessDetectionHeatmapNoResults, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 24
      }
    }),
    xDomain: xDomain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Heatmap, {
    id: 'privileged-access-detection-heatmap-chart',
    xScale: {
      type: _charts.ScaleType.Time,
      interval: {
        type: 'fixed',
        value: intervalForHeatmap,
        unit: 'h'
      }
    },
    colorScale: {
      type: 'bands',
      bands: anomalyBands
    },
    data: records,
    name: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetections.maxAnomalyScore', {
      defaultMessage: 'Max anomaly score'
    }),
    xAccessor: "@timestamp",
    xAxisLabelName: '',
    xAxisLabelFormatter: timeFormatter,
    yAccessor: "user.name",
    yAxisLabelName: 'user.name',
    ySortPredicate: "numDesc",
    valueAccessor: "record_score",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  })));
};
exports.PrivilegedAccessDetectionHeatmap = PrivilegedAccessDetectionHeatmap;