"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionDuplicateExceptionsConfirmation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/detection_engine/rule_management/constants");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/bulk_duplicate_exceptions_confirmation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BulkActionDuplicateExceptionsConfirmationComponent = ({
  onCancel,
  onConfirm,
  rulesCount
}) => {
  const [selectedDuplicateOption, setSelectedDuplicateOption] = (0, _react.useState)(_constants.DuplicateOptions.withExceptions);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const handleRadioChange = (0, _react.useCallback)(optionId => {
    setSelectedDuplicateOption(optionId);
  }, [setSelectedDuplicateOption]);
  const handleConfirm = (0, _react.useCallback)(() => {
    onConfirm(selectedDuplicateOption);
  }, [onConfirm, selectedDuplicateOption]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _translations.bulkDuplicateRuleActions.MODAL_TITLE(rulesCount),
    onConfirm: handleConfirm,
    cancelButtonText: _translations.bulkDuplicateRuleActions.CANCEL_BUTTON,
    confirmButtonText: _translations.bulkDuplicateRuleActions.CONTINUE_BUTTON,
    defaultFocusedButton: "confirm",
    onCancel: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, _translations.bulkDuplicateRuleActions.MODAL_TEXT(rulesCount)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "duplicateExceptionOption",
    options: [{
      id: _constants.DuplicateOptions.withExceptions,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 15
        }
      }, _translations.bulkDuplicateRuleActions.DUPLICATE_EXCEPTIONS_INCLUDE_EXPIRED_EXCEPTIONS_LABEL(rulesCount), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.bulkDuplicateRuleActions.DUPLICATE_TOOLTIP,
        position: "bottom",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 17
        }
      })),
      'data-test-subj': _constants.DuplicateOptions.withExceptions
    }, {
      id: _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 15
        }
      }, _translations.bulkDuplicateRuleActions.DUPLICATE_EXCEPTIONS_TEXT(rulesCount), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.bulkDuplicateRuleActions.DUPLICATE_TOOLTIP,
        position: "bottom",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 17
        }
      })),
      'data-test-subj': _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions
    }, {
      id: _constants.DuplicateOptions.withoutExceptions,
      label: _translations.bulkDuplicateRuleActions.DUPLICATE_WITHOUT_EXCEPTIONS_TEXT(rulesCount),
      'data-test-subj': _constants.DuplicateOptions.withoutExceptions
    }],
    idSelected: selectedDuplicateOption,
    onChange: handleRadioChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
};
const BulkActionDuplicateExceptionsConfirmation = exports.BulkActionDuplicateExceptionsConfirmation = /*#__PURE__*/_react.default.memo(BulkActionDuplicateExceptionsConfirmationComponent);
BulkActionDuplicateExceptionsConfirmation.displayName = 'BulkActionDuplicateExceptionsConfirmation';