"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddPrebuiltRulesTableContext = exports.AddPrebuiltRulesTableContextProvider = void 0;
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../../common/utils/invariant");
var _user_info = require("../../../../../detections/components/user_info");
var _use_fetch_prebuilt_rules_status_query = require("../../../../rule_management/api/hooks/prebuilt_rules/use_fetch_prebuilt_rules_status_query");
var _use_perform_all_rules_install_mutation = require("../../../../rule_management/api/hooks/prebuilt_rules/use_perform_all_rules_install_mutation");
var _use_perform_rule_install = require("../../../../rule_management/logic/prebuilt_rules/use_perform_rule_install");
var _use_prebuilt_rules_install_review = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_install_review");
var _use_upgrade_security_packages = require("../../../../rule_management/logic/use_upgrade_security_packages");
var _use_rule_preview_flyout = require("../use_rule_preview_flyout");
var _add_prebuilt_rules_utils = require("./add_prebuilt_rules_utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_filter_prebuilt_rules_to_install = require("./use_filter_prebuilt_rules_to_install");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddPrebuiltRulesTableContext = /*#__PURE__*/(0, _react.createContext)(null);
const PREBUILT_RULE_INSTALL_FLYOUT_ANCHOR = 'installPrebuiltRulePreview';
const AddPrebuiltRulesTableContextProvider = ({
  children
}) => {
  const [loadingRules, setLoadingRules] = (0, _react.useState)([]);
  const [selectedRules, setSelectedRules] = (0, _react.useState)([]);
  const [{
    loading: userInfoLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const [filterOptions, setFilterOptions] = (0, _react.useState)({
    filter: '',
    tags: []
  });
  const {
    data: prebuiltRulesStatus
  } = (0, _use_fetch_prebuilt_rules_status_query.useFetchPrebuiltRulesStatusQuery)();
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const isInstallingAllRules = (0, _reactQuery.useIsMutating)({
    mutationKey: _use_perform_all_rules_install_mutation.PERFORM_ALL_RULES_INSTALLATION_KEY
  }) > 0;
  const {
    data: {
      rules,
      stats: {
        tags
      }
    } = {
      rules: [],
      stats: {
        tags: []
      }
    },
    refetch,
    dataUpdatedAt,
    isFetched,
    isLoading,
    isRefetching
  } = (0, _use_prebuilt_rules_install_review.usePrebuiltRulesInstallReview)({
    refetchInterval: 60000,
    // Refetch available rules for installation every minute
    keepPreviousData: true,
    // Use this option so that the state doesn't jump between "success" and "loading" on page change
    // Fetch rules to install only after background installation of security_detection_rules package is complete
    enabled: (0, _add_prebuilt_rules_utils.isUpgradeReviewRequestEnabled)({
      canUserCRUD,
      isUpgradingSecurityPackages,
      prebuiltRulesStatus: prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.stats
    })
  });
  const isAnyRuleInstalling = loadingRules.length > 0 || isInstallingAllRules;
  const {
    mutateAsync: installAllRulesRequest
  } = (0, _use_perform_rule_install.usePerformInstallAllRules)();
  const {
    mutateAsync: installSpecificRulesRequest
  } = (0, _use_perform_rule_install.usePerformInstallSpecificRules)();
  const filteredRules = (0, _use_filter_prebuilt_rules_to_install.useFilterPrebuiltRulesToInstall)({
    filterOptions,
    rules
  });
  const installOneRule = (0, _react.useCallback)(async (ruleId, enable) => {
    const rule = rules.find(r => r.rule_id === ruleId);
    (0, _invariant.invariant)(rule, `Rule with id ${ruleId} not found`);
    setLoadingRules(prev => [...prev, ruleId]);
    try {
      await installSpecificRulesRequest({
        rules: [{
          rule_id: ruleId,
          version: rule.version
        }],
        enable
      });
    } catch {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setLoadingRules(prev => prev.filter(id => id !== ruleId));
    }
  }, [installSpecificRulesRequest, rules]);
  const installSelectedRules = (0, _react.useCallback)(async enable => {
    const rulesToUpgrade = selectedRules.map(rule => ({
      rule_id: rule.rule_id,
      version: rule.version
    }));
    setLoadingRules(prev => [...prev, ...rulesToUpgrade.map(r => r.rule_id)]);
    try {
      await installSpecificRulesRequest({
        rules: rulesToUpgrade,
        enable
      });
    } catch {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setLoadingRules(prev => prev.filter(id => !rulesToUpgrade.some(r => r.rule_id === id)));
      setSelectedRules([]);
    }
  }, [installSpecificRulesRequest, selectedRules]);
  const installAllRules = (0, _react.useCallback)(async () => {
    // Unselect all rules so that the table doesn't show the "bulk actions" bar
    setLoadingRules(prev => [...prev, ...rules.map(r => r.rule_id)]);
    try {
      await installAllRulesRequest();
    } catch {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setLoadingRules([]);
      setSelectedRules([]);
    }
  }, [installAllRulesRequest, rules]);
  const ruleActionsFactory = (0, _react.useCallback)((rule, closeRulePreview) => {
    const isPreviewRuleLoading = loadingRules.includes(rule.rule_id);
    const canPreviewedRuleBeInstalled = !userInfoLoading && canUserCRUD && !(isPreviewRuleLoading || isRefetching || isUpgradingSecurityPackages);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canPreviewedRuleBeInstalled,
      onClick: () => {
        installOneRule(rule.rule_id);
        closeRulePreview();
      },
      "data-test-subj": "installPrebuiltRuleFromFlyoutButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 13
      }
    }, i18n.INSTALL_WITHOUT_ENABLING_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canPreviewedRuleBeInstalled,
      onClick: () => {
        installOneRule(rule.rule_id, true);
        closeRulePreview();
      },
      fill: true,
      "data-test-subj": "installAndEnablePrebuiltRuleFromFlyoutButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 13
      }
    }, i18n.INSTALL_AND_ENABLE_BUTTON_LABEL)));
  }, [loadingRules, userInfoLoading, canUserCRUD, isRefetching, isUpgradingSecurityPackages, installOneRule]);
  const {
    rulePreviewFlyout,
    openRulePreview
  } = (0, _use_rule_preview_flyout.useRulePreviewFlyout)({
    rules: filteredRules,
    ruleActionsFactory,
    flyoutProps: {
      id: PREBUILT_RULE_INSTALL_FLYOUT_ANCHOR,
      dataTestSubj: PREBUILT_RULE_INSTALL_FLYOUT_ANCHOR
    }
  });
  const actions = (0, _react.useMemo)(() => ({
    setFilterOptions,
    installAllRules,
    installOneRule,
    installSelectedRules,
    reFetchRules: refetch,
    selectRules: setSelectedRules,
    openRulePreview
  }), [installAllRules, installOneRule, installSelectedRules, refetch, openRulePreview]);
  const providerValue = (0, _react.useMemo)(() => {
    return {
      state: {
        rules: filteredRules,
        filterOptions,
        tags,
        hasRulesToInstall: isFetched && rules.length > 0,
        isFetched,
        isLoading,
        loadingRules,
        isRefetching,
        isUpgradingSecurityPackages,
        isInstallingAllRules,
        isAnyRuleInstalling,
        selectedRules,
        lastUpdated: dataUpdatedAt
      },
      actions
    };
  }, [rules, filteredRules, filterOptions, tags, isFetched, isLoading, loadingRules, isRefetching, isUpgradingSecurityPackages, isInstallingAllRules, isAnyRuleInstalling, selectedRules, dataUpdatedAt, actions]);
  return /*#__PURE__*/_react.default.createElement(AddPrebuiltRulesTableContext.Provider, {
    value: providerValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, rulePreviewFlyout));
};
exports.AddPrebuiltRulesTableContextProvider = AddPrebuiltRulesTableContextProvider;
const useAddPrebuiltRulesTableContext = () => {
  const rulesTableContext = (0, _react.useContext)(AddPrebuiltRulesTableContext);
  (0, _invariant.invariant)(rulesTableContext, 'useAddPrebuiltRulesTableContext should be used inside AddPrebuiltRulesTableContextProvider');
  return rulesTableContext;
};
exports.useAddPrebuiltRulesTableContext = useAddPrebuiltRulesTableContext;