"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlRuleFieldReadOnly = EsqlRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _esql_query = require("./fields/esql_query/esql_query");
var _type = require("./fields/type/type");
var _alert_suppression = require("./fields/alert_suppression/alert_suppression");
var _utility_types = require("../../../../../../../common/utility_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/esql_rule_field_readonly.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EsqlRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionReadOnly, {
        alertSuppression: finalDiffableRule.alert_suppression,
        ruleType: finalDiffableRule.type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 9
        }
      });
    case 'esql_query':
      return /*#__PURE__*/_react.default.createElement(_esql_query.EsqlQueryReadOnly, {
        esqlQuery: finalDiffableRule.esql_query,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 14
        }
      });
    case 'type':
      return /*#__PURE__*/_react.default.createElement(_type.TypeReadOnly, {
        type: finalDiffableRule.type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 14
        }
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}