"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionLogTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../../../data_view_manager/constants");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _kuery = require("../../../../../common/lib/kuery");
var _constants2 = require("../../../../../common/store/inputs/constants");
var _constants3 = require("../../../../../../common/constants");
var _use_rule_details_tabs = require("../use_rule_details_tabs");
var _header_section = require("../../../../../common/components/header_section");
var _utility_bar = require("../../../../../common/components/utility_bar");
var _containers = require("../../../../../sourcerer/containers");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _kibana = require("../../../../../common/lib/kibana");
var _store = require("../../../../../common/store");
var _actions = require("../../../../../common/store/inputs/actions");
var _model = require("../../../../../common/store/inputs/model");
var _rule_monitoring = require("../../../../rule_monitoring");
var _rule_details_context = require("../rule_details_context");
var _use_expandable_rows = require("../../../../rule_monitoring/components/basic/tables/use_expandable_rows");
var _text_block = require("../../../../rule_monitoring/components/basic/text/text_block");
var i18n = _interopRequireWildcard(require("./translations"));
var _execution_log_columns = require("./execution_log_columns");
var _execution_log_search_bar = require("./execution_log_search_bar");
var _telemetry = require("../../../../../common/lib/telemetry");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/execution_log_table/execution_log_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EXECUTION_UUID_FIELD_NAME = 'kibana.alert.rule.execution.uuid';
const UtilitySwitch = (0, _styledComponents.default)(_eui.EuiSwitch)`
  margin-left: 17px;
`;
const DatePickerEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 582px;
`;
const ExecutionLogTableComponent = ({
  ruleId,
  selectAlertsTab,
  ...startServices
}) => {
  var _events$events, _events$total;
  const {
    docLinks,
    data: {
      query: {
        filterManager
      }
    },
    storage,
    timelines,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    [_use_rule_details_tabs.RuleDetailTabs.executionResults]: {
      state: {
        superDatePicker: {
          recentlyUsedRanges,
          refreshInterval,
          isPaused,
          start,
          end
        },
        queryText,
        statusFilters,
        runTypeFilters,
        showMetricColumns,
        showSourceEventTimeRange,
        pagination: {
          pageIndex,
          pageSize
        },
        sort: {
          sortField,
          sortDirection
        }
      },
      actions: {
        setEnd,
        setIsPaused,
        setPageIndex,
        setPageSize,
        setQueryText,
        setRecentlyUsedRanges,
        setRefreshInterval,
        setShowMetricColumns,
        setSortDirection,
        setSortField,
        setStart,
        setStatusFilters,
        setRunTypeFilters,
        setShowSourceEventTimeRange
      }
    }
  } = (0, _rule_details_context.useRuleDetailsContext)();

  // Index for `add filter` action and toasts for errors
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(_constants.PageScope.alerts);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants.PageScope.alerts);
  const {
    addError,
    addSuccess,
    remove
  } = (0, _use_app_toasts.useAppToasts)();

  // QueryString, Filters, and TimeRange state
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const timerange = (0, _use_selector.useDeepEqualSelector)(_store.inputsSelectors.globalTimeRangeSelector);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const cachedGlobalQueryState = (0, _react.useRef)({
    filters,
    query,
    timerange
  });
  const successToastId = (0, _react.useRef)('');
  const resetGlobalQueryState = (0, _react.useCallback)(() => {
    if ((0, _model.isAbsoluteTimeRange)(cachedGlobalQueryState.current.timerange)) {
      dispatch((0, _actions.setAbsoluteRangeDatePicker)({
        id: _constants2.InputsModelId.global,
        from: cachedGlobalQueryState.current.timerange.from,
        to: cachedGlobalQueryState.current.timerange.to
      }));
    } else if ((0, _model.isRelativeTimeRange)(cachedGlobalQueryState.current.timerange)) {
      dispatch((0, _actions.setRelativeRangeDatePicker)({
        id: _constants2.InputsModelId.global,
        from: cachedGlobalQueryState.current.timerange.from,
        fromStr: cachedGlobalQueryState.current.timerange.fromStr,
        to: cachedGlobalQueryState.current.timerange.to,
        toStr: cachedGlobalQueryState.current.timerange.toStr
      }));
    }
    dispatch((0, _actions.setFilterQuery)({
      id: _constants2.InputsModelId.global,
      query: cachedGlobalQueryState.current.query.query,
      language: cachedGlobalQueryState.current.query.language
    }));
    // Using filterManager directly as dispatch(setSearchBarFilter()) was not replacing filters
    filterManager.removeAll();
    filterManager.addFilters(cachedGlobalQueryState.current.filters);
    remove(successToastId.current);
  }, [dispatch, filterManager, remove]);

  // Table data state
  const {
    data: events,
    dataUpdatedAt,
    isFetching,
    isLoading,
    refetch
  } = (0, _rule_monitoring.useExecutionResults)({
    ruleId,
    start,
    end,
    queryText,
    statusFilters,
    runTypeFilters,
    page: pageIndex,
    perPage: pageSize,
    sortField,
    sortOrder: sortDirection
  });
  const items = (_events$events = events === null || events === void 0 ? void 0 : events.events) !== null && _events$events !== void 0 ? _events$events : [];
  const maxEvents = (_events$total = events === null || events === void 0 ? void 0 : events.total) !== null && _events$total !== void 0 ? _events$total : 0;

  // Cache UUID field from data view as it can be expensive to iterate all data view fields
  const uuidDataViewField = (0, _react.useMemo)(() => {
    var _experimentalDataView, _oldSourcererDataView;
    return newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.fields) === null || _experimentalDataView === void 0 ? void 0 : _experimentalDataView.getByName(EXECUTION_UUID_FIELD_NAME) : (_oldSourcererDataView = oldSourcererDataView.fields) === null || _oldSourcererDataView === void 0 ? void 0 : _oldSourcererDataView[EXECUTION_UUID_FIELD_NAME];
  }, [experimentalDataView, newDataViewPickerEnabled, oldSourcererDataView.fields]);

  // Callbacks
  const onTableChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index + 1);
    setPageSize(size);
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, [setPageIndex, setPageSize, setSortDirection, setSortField]);
  const onTimeChangeCallback = (0, _react.useCallback)(props => {
    const recentlyUsedRange = recentlyUsedRanges.filter(range => {
      const isDuplicate = range.start === props.start && range.end === props.end;
      return !isDuplicate;
    });
    recentlyUsedRange.unshift({
      start: props.start,
      end: props.end
    });
    setStart(props.start);
    setEnd(props.end);
    setRecentlyUsedRanges(recentlyUsedRange.length > 10 ? recentlyUsedRange.slice(0, 9) : recentlyUsedRange);
  }, [recentlyUsedRanges, setEnd, setRecentlyUsedRanges, setStart]);
  const onRefreshChangeCallback = (0, _react.useCallback)(props => {
    setIsPaused(props.isPaused);
    // Only support auto-refresh >= 1minute -- no current ability to limit within component
    setRefreshInterval(props.refreshInterval > 60000 ? props.refreshInterval : 60000);
  }, [setIsPaused, setRefreshInterval]);
  const onRefreshCallback = (0, _react.useCallback)(props => {
    refetch();
  }, [refetch]);
  const onSearchCallback = (0, _react.useCallback)(updatedQueryText => {
    setQueryText(updatedQueryText);
  }, [setQueryText]);
  const onStatusFilterChangeCallback = (0, _react.useCallback)(updatedStatusFilters => {
    setStatusFilters(updatedStatusFilters);
  }, [setStatusFilters]);
  const onFilterByExecutionIdCallback = (0, _react.useCallback)((executionId, executionStart) => {
    const dataViewAsViewBase = newDataViewPickerEnabled ? experimentalDataView : (0, _kuery.dataViewSpecToViewBase)(oldSourcererDataView);
    if (uuidDataViewField != null && typeof uuidDataViewField !== 'undefined' && dataViewAsViewBase) {
      // Update cached global query state with current state as a rollback point
      cachedGlobalQueryState.current = {
        filters,
        query,
        timerange
      };
      // Create filter & daterange constraints
      const filter = (0, _esQuery.buildFilter)(dataViewAsViewBase, uuidDataViewField, _esQuery.FILTERS.PHRASE, false, false, executionId, null);
      dispatch((0, _actions.setAbsoluteRangeDatePicker)({
        id: _constants2.InputsModelId.global,
        from: (0, _moment.default)(executionStart).subtract(1, 'days').toISOString(),
        to: (0, _moment.default)(executionStart).add(1, 'days').toISOString()
      }));
      filterManager.removeAll();
      filterManager.addFilters(filter);
      dispatch((0, _actions.setFilterQuery)({
        id: _constants2.InputsModelId.global,
        query: '',
        language: 'kuery'
      }));
      selectAlertsTab();
      successToastId.current = addSuccess({
        title: i18n.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_TITLE,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 351,
            columnNumber: 17
          }
        }, i18n.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 352,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 353,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          onClick: resetGlobalQueryState,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 354,
            columnNumber: 21
          }
        }, i18n.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_RESTORE_BUTTON)))), startServices)
      },
      // Essentially keep toast around till user dismisses via 'x'
      {
        toastLifeTimeMs: 10 * 60 * 1000
      }).id;
    } else {
      addError(i18n.ACTIONS_FIELD_NOT_FOUND_ERROR, {
        title: i18n.ACTIONS_FIELD_NOT_FOUND_ERROR_TITLE
      });
    }
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataView, uuidDataViewField, filters, query, timerange, dispatch, filterManager, selectAlertsTab, addSuccess, resetGlobalQueryState, startServices, addError]);
  const onShowSourceEventTimeRange = (0, _react.useCallback)(showEventTimeRange => {
    storage.set(_constants3.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_SOURCE_EVENT_TIME_RANGE_STORAGE_KEY, showEventTimeRange);
    setShowSourceEventTimeRange(showEventTimeRange);
  }, [setShowSourceEventTimeRange, storage]);
  const onShowMetricColumnsCallback = (0, _react.useCallback)(showMetrics => {
    storage.set(_constants3.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY, showMetrics);
    setShowMetricColumns(showMetrics);
  }, [setShowMetricColumns, storage]);

  // Memoized state
  const pagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: pageIndex - 1,
      pageSize,
      totalItemCount: maxEvents > _securitysolutionRules.MAX_EXECUTION_EVENTS_DISPLAYED ? _securitysolutionRules.MAX_EXECUTION_EVENTS_DISPLAYED : maxEvents,
      pageSizeOptions: [5, 10, 25, 50]
    };
  }, [maxEvents, pageIndex, pageSize]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortDirection, sortField]);
  const actions = (0, _react.useMemo)(() => [{
    field: EXECUTION_UUID_FIELD_NAME,
    name: i18n.COLUMN_ACTIONS,
    width: '64px',
    actions: [{
      name: 'Edit',
      isPrimary: true,
      field: '',
      description: i18n.COLUMN_ACTIONS_TOOLTIP,
      icon: 'filter',
      type: 'icon',
      onClick: executionEvent => {
        if (executionEvent !== null && executionEvent !== void 0 && executionEvent.execution_uuid) {
          onFilterByExecutionIdCallback(executionEvent.execution_uuid, executionEvent.timestamp);
        }
      },
      'data-test-subj': 'action-filter-by-execution-id'
    }]
  }], [onFilterByExecutionIdCallback]);
  const getItemId = (0, _react.useCallback)(item => {
    return `${item.execution_uuid}`;
  }, []);
  const renderExpandedItem = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "eui-fullWidth",
    listItems: [{
      title: i18n.ROW_DETAILS_MESSAGE,
      description: /*#__PURE__*/_react.default.createElement(_text_block.TextBlock, {
        text: item.security_message,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 470,
          columnNumber: 26
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 7
    }
  }), []);
  const rows = (0, _use_expandable_rows.useExpandableRows)({
    getItemId,
    renderItem: renderExpandedItem
  });
  const handleShowSourceEventTimeRange = (0, _react.useCallback)(e => {
    const isVisible = e.target.checked;
    onShowSourceEventTimeRange(isVisible);
    telemetry.reportEvent(_telemetry.EventLogEventTypes.EventLogShowSourceEventDateRange, {
      isVisible
    });
  }, [onShowSourceEventTimeRange, telemetry]);
  const executionLogColumns = (0, _react.useMemo)(() => {
    const columns = [..._execution_log_columns.EXECUTION_LOG_COLUMNS];
    let messageColumnWidth = 50;
    if (showSourceEventTimeRange) {
      columns.push(...(0, _execution_log_columns.getSourceEventTimeRangeColumns)());
      messageColumnWidth = 30;
    }
    if (showMetricColumns) {
      messageColumnWidth = 20;
      columns.push((0, _execution_log_columns.getMessageColumn)(`${messageColumnWidth}%`), ...(0, _execution_log_columns.getExecutionLogMetricsColumns)(docLinks));
    } else {
      columns.push((0, _execution_log_columns.getMessageColumn)(`${messageColumnWidth}%`));
    }
    columns.push(...actions, (0, _execution_log_columns.expanderColumn)({
      toggleRowExpanded: rows.toggleRowExpanded,
      isRowExpanded: rows.isRowExpanded
    }));
    return columns;
  }, [actions, docLinks, showMetricColumns, showSourceEventTimeRange, rows.toggleRowExpanded, rows.isRowExpanded]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "executionLogContainer",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 532,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 534,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.TABLE_TITLE,
    subtitle: i18n.TABLE_SUBTITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 536,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_execution_log_search_bar.ExecutionLogSearchBar, {
    onlyShowFilters: true,
    selectedStatuses: statusFilters,
    onStatusFilterChange: onStatusFilterChangeCallback,
    onSearch: onSearchCallback,
    selectedRunTypes: runTypeFilters,
    onRunTypeFilterChange: setRunTypeFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(DatePickerEuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: start,
    end: end,
    onTimeChange: onTimeChangeCallback,
    onRefresh: onRefreshCallback,
    isPaused: isPaused,
    isLoading: isFetching,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChangeCallback,
    recentlyUsedRanges: recentlyUsedRanges,
    width: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 564,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 567,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 568,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 569,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "executionsShowing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 570,
      columnNumber: 13
    }
  }, i18n.SHOWING_EXECUTIONS(maxEvents > _securitysolutionRules.MAX_EXECUTION_EVENTS_DISPLAYED ? _securitysolutionRules.MAX_EXECUTION_EVENTS_DISPLAYED : maxEvents))), maxEvents > _securitysolutionRules.MAX_EXECUTION_EVENTS_DISPLAYED && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "exceptionsShowing",
    shouldWrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 17
    }
  }, i18n.RULE_EXECUTION_LOG_SEARCH_LIMIT_EXCEEDED(maxEvents, _securitysolutionRules.MAX_EXECUTION_EVENTS_DISPLAYED))))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 591,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "lastUpdated",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 13
    }
  }, timelines.getLastUpdated({
    showUpdating: isLoading || isFetching,
    updatedAt: dataUpdatedAt
  })), /*#__PURE__*/_react.default.createElement(UtilitySwitch, {
    label: i18n.RULE_EXECUTION_LOG_SHOW_SOURCE_EVENT_TIME_RANGE,
    checked: showSourceEventTimeRange,
    compressed: true,
    onChange: handleShowSourceEventTimeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 599,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(UtilitySwitch, {
    label: i18n.RULE_EXECUTION_LOG_SHOW_METRIC_COLUMNS_SWITCH,
    checked: showMetricColumns,
    compressed: true,
    onChange: e => onShowMetricColumnsCallback(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 605,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: executionLogColumns,
    items: items,
    loading: isFetching,
    sorting: sorting,
    pagination: pagination,
    onChange: onTableChangeCallback,
    itemId: getItemId,
    itemIdToExpandedRowMap: rows.itemIdToExpandedRowMap,
    "data-test-subj": "executionsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 7
    }
  }));
};
const ExecutionLogTable = exports.ExecutionLogTable = /*#__PURE__*/_react.default.memo(ExecutionLogTableComponent);
ExecutionLogTable.displayName = 'ExecutionLogTable';